/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrick.template.Errors;
import jetbrick.template.JetGlobalContext;
import jetbrick.template.parser.ast.AstDirectiveMacro;
import jetbrick.template.resolver.GlobalResolver;
import jetbrick.template.resolver.clazz.ClassResolver;

public final class ParserContext {
    private boolean strict;
    private boolean safecall;
    private boolean trimLeadingWhitespaces;
    private boolean trimDirectiveWhitespaces;
    private boolean trimDirectiveComments;
    private String trimDirectiveCommentsPrefix;
    private String trimDirectiveCommentsSuffix;
    private boolean nullSafe;
    private final GlobalResolver globalResolver;
    private ClassResolver localClassResolver;
    private final JetGlobalContext globalContext;
    private final Map<String, Class<?>> localSymbols;
    private Map<String, Class<?>> currentSymbols;
    private List<String> loadMacroFiles;
    private List<AstDirectiveMacro> declaredMacros;

    public ParserContext(GlobalResolver globalResolver, JetGlobalContext globalContext) {
        this.globalResolver = globalResolver;
        this.globalContext = globalContext;
        this.localSymbols = new HashMap();
        this.currentSymbols = this.localSymbols;
        this.nullSafe = false;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isSafecall() {
        return this.safecall;
    }

    public void setSafecall(boolean safecall) {
        this.safecall = safecall;
    }

    public boolean isTrimLeadingWhitespaces() {
        return this.trimLeadingWhitespaces;
    }

    public void setTrimLeadingWhitespaces(boolean trimLeadingWhitespaces) {
        this.trimLeadingWhitespaces = trimLeadingWhitespaces;
    }

    public boolean isTrimDirectiveWhitespaces() {
        return this.trimDirectiveWhitespaces;
    }

    public void setTrimDirectiveWhitespaces(boolean trimDirectiveWhitespaces) {
        this.trimDirectiveWhitespaces = trimDirectiveWhitespaces;
    }

    public boolean isTrimDirectiveComments() {
        return this.trimDirectiveComments;
    }

    public void setTrimDirectiveComments(boolean trimDirectiveComments) {
        this.trimDirectiveComments = trimDirectiveComments;
    }

    public String getTrimDirectiveCommentsPrefix() {
        return this.trimDirectiveCommentsPrefix;
    }

    public void setTrimDirectiveCommentsPrefix(String trimDirectiveCommentsPrefix) {
        this.trimDirectiveCommentsPrefix = trimDirectiveCommentsPrefix;
    }

    public String getTrimDirectiveCommentsSuffix() {
        return this.trimDirectiveCommentsSuffix;
    }

    public void setTrimDirectiveCommentsSuffix(String trimDirectiveCommentsSuffix) {
        this.trimDirectiveCommentsSuffix = trimDirectiveCommentsSuffix;
    }

    public boolean isNullSafe() {
        return this.nullSafe;
    }

    public void setNullSafe(boolean nullSafe) {
        this.nullSafe = nullSafe;
    }

    public void importClass(String name) {
        if (this.localClassResolver == null) {
            this.localClassResolver = new ClassResolver();
        }
        this.localClassResolver.importClass(name);
    }

    public Class<?> resolveClass(String className) {
        Class<?> cls = null;
        if (this.localClassResolver != null) {
            cls = this.localClassResolver.resolveClass(className);
        }
        if (cls == null) {
            cls = this.globalResolver.resolveClass(className);
        }
        return cls;
    }

    public void enterMacros() {
        this.currentSymbols = new LinkedHashMap();
    }

    public void exitMacros() {
        this.currentSymbols = this.localSymbols;
    }

    public void defineSymbol(String name, Class<?> type) throws IllegalStateException {
        this.defineSymbol(name, type, false);
    }

    public void defineSymbol(String name, Class<?> type, boolean allowSameRedefine) throws IllegalStateException {
        if (type == null && this.strict) {
            throw new IllegalStateException(Errors.format("argument type is missing in strict mode: %s", name));
        }
        if (this.currentSymbols.containsKey(name)) {
            Class<?> old = this.currentSymbols.get(name);
            if (allowSameRedefine && type == old) {
                return;
            }
            if (old == null) {
                throw new IllegalStateException(Errors.format("cannot define variable after use it: %s", name));
            }
            throw new IllegalStateException(Errors.format("cannot redefine variable: %s", name));
        }
        this.currentSymbols.put(name, type);
    }

    public void useSymbol(String name) throws IllegalStateException {
        if (this.currentSymbols.containsKey(name)) {
            return;
        }
        Class<?> type = this.globalContext.getType(name);
        this.currentSymbols.put(name, type);
        if (type == null && this.strict) {
            throw new IllegalStateException(Errors.format("undefined variable found in strict mode: %s", name));
        }
    }

    public Map<String, Class<?>> getSymbols() {
        return this.currentSymbols;
    }

    public List<String> getMacroArgumentNames() {
        if (this.currentSymbols instanceof LinkedHashMap) {
            if (this.currentSymbols.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(this.currentSymbols.keySet());
        }
        throw new UnsupportedOperationException("unreachable code");
    }

    public void loadMacroFile(String file) {
        if (this.loadMacroFiles == null) {
            this.loadMacroFiles = new ArrayList<String>(4);
        }
        this.loadMacroFiles.add(file);
    }

    public void defineMacro(AstDirectiveMacro macro) {
        if (this.declaredMacros == null) {
            this.declaredMacros = new ArrayList<AstDirectiveMacro>(8);
        } else {
            for (AstDirectiveMacro old : this.declaredMacros) {
                if (!macro.getName().equals(old.getName())) continue;
                throw new IllegalStateException(Errors.format("duplicated macro name: %s", macro.getName()));
            }
        }
        this.declaredMacros.add(macro);
    }

    public List<String> getLoadMacroFiles() {
        return this.loadMacroFiles;
    }

    public List<AstDirectiveMacro> getDeclaredMacros() {
        return this.declaredMacros;
    }
}

