/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser;

import jetbrick.template.parser.AstCodeVisitor;
import jetbrick.template.parser.ParserContext;
import jetbrick.template.parser.Source;
import jetbrick.template.parser.SyntaxException;
import jetbrick.template.parser.ast.AstTemplate;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.parser.grammer.JetTemplateLexer;
import jetbrick.template.runtime.parser.grammer.JetTemplateParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class AstBuilder {
    public static AstTemplate create(Source source, ParserContext ctx) {
        char[] contents = source.getContents();
        ANTLRInputStream is = new ANTLRInputStream(contents, contents.length);
        is.name = source.getFilename();
        JetTemplateLexer lexer = new JetTemplateLexer((CharStream)is);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)AstErrorListener.instance);
        JetTemplateParser parser = new JetTemplateParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)AstErrorListener.instance);
        parser.setErrorHandler((ANTLRErrorStrategy)new AstErrorStrategy());
        try {
            AstCodeVisitor visitor = new AstCodeVisitor(ctx);
            return visitor.visitTemplate(parser.template());
        }
        catch (SyntaxException e) {
            throw e.set(source);
        }
    }

    static class AstErrorStrategy
    extends DefaultErrorStrategy {
        AstErrorStrategy() {
        }

        public void recover(Parser recognizer, RecognitionException e) {
            int line = e.getOffendingToken().getLine();
            int column = e.getOffendingToken().getCharPositionInLine();
            Position position = new Position(line, column);
            throw new SyntaxException((Throwable)e).set(position);
        }

        public Token recoverInline(Parser recognizer) throws RecognitionException {
            this.reportMissingToken(recognizer);
            return null;
        }
    }

    static class AstErrorListener
    extends BaseErrorListener {
        private static final AstErrorListener instance = new AstErrorListener();

        AstErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            Position position = new Position(line, charPositionInLine);
            throw new SyntaxException(msg).set(position);
        }
    }
}

