/*
 * Decompiled with CFR 0.152.
 */
package redis.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufIndexFinder;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.io.IOException;
import redis.netty4.Command;
import redis.netty4.RedisReplyDecoder;
import redis.server.netty.RedisException;

public class RedisCommandDecoder
extends ReplayingDecoder<Void> {
    private byte[][] bytes;
    private int arguments = 0;

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.alloc().directBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, MessageBuf<Object> out) throws Exception {
        if (this.bytes != null) {
            int numArgs = this.bytes.length;
            for (int i = this.arguments; i < numArgs; ++i) {
                if (in.readByte() == 36) {
                    long l = RedisReplyDecoder.readLong((ByteBuf)in);
                    if (l > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
                    }
                    int size = (int)l;
                    this.bytes[i] = new byte[size];
                    in.readBytes(this.bytes[i]);
                    if (in.bytesBefore(ByteBufIndexFinder.CRLF) != 0) {
                        throw new RedisException("Argument doesn't end in CRLF");
                    }
                    in.skipBytes(2);
                    ++this.arguments;
                } else {
                    throw new IOException("Unexpected character");
                }
                this.checkpoint();
            }
            try {
                out.add((Object)new Command((Object[])this.bytes));
            }
            finally {
                this.bytes = null;
                this.arguments = 0;
            }
        } else if (in.readByte() == 42) {
            long l = RedisReplyDecoder.readLong((ByteBuf)in);
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
            }
            int numArgs = (int)l;
            if (numArgs < 0) {
                throw new RedisException("Invalid size: " + numArgs);
            }
            this.bytes = new byte[numArgs][];
            this.checkpoint();
            this.decode(ctx, in, out);
        } else {
            in.readerIndex(in.readerIndex() - 1);
            byte[][] b = new byte[][]{in.readBytes(in.bytesBefore(ByteBufIndexFinder.CRLF)).array()};
            in.skipBytes(2);
            out.add((Object)new Command((Object[])b, true));
        }
    }
}

