/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.rest.spring;

import com.github.skjolber.mockito.rest.spring.DefaultSpringWebMvcConfig;
import com.github.skjolber.mockito.rest.spring.MockitoSpringConfiguration;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.dynamic.DynamicType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.rules.ExternalResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class RestServiceRule
extends ExternalResource {
    private List<Class<?>> defaultContextBeans;
    private List<Server> servers = new ArrayList<Server>();

    public static <T> Class<T> asService(Class<T> serviceInterface) throws Exception {
        return RestServiceRule.asService(serviceInterface, null);
    }

    public static <T> Class<T> asService(Class<T> serviceInterface, String path) throws Exception {
        DynamicType.Builder subclass = new ByteBuddy().subclass(serviceInterface);
        if (!serviceInterface.isAnnotationPresent(RestController.class) && !serviceInterface.isAnnotationPresent(Controller.class)) {
            subclass = subclass.annotateType(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(RestController.class).build()});
        }
        if (path != null) {
            subclass = subclass.annotateType(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(RequestMapping.class).defineArray("path", new String[]{path}).build()});
        }
        DynamicType.Loaded load = subclass.make().load(serviceInterface.getClassLoader());
        return load.getLoaded();
    }

    public static RestServiceRule newInstance() {
        return new RestServiceRule();
    }

    public static RestServiceRule newInstance(List<Class<?>> beans) {
        return new RestServiceRule(beans);
    }

    public RestServiceRule() {
        this(Arrays.asList(DefaultSpringWebMvcConfig.class));
    }

    public RestServiceRule(List<Class<?>> contextBeans) {
        this.defaultContextBeans = contextBeans;
    }

    public Map<Class<?>, Object> mock(List<Class<?>> serviceInterfaces, String address) throws Exception {
        return this.mock(serviceInterfaces, this.defaultContextBeans, address);
    }

    public Map<Class<?>, Object> mock(List<Class<?>> serviceInterfaces, List<Class<?>> contextBeans, String address) throws Exception {
        URL url = new URL(address);
        if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
            throw new IllegalArgumentException("Only local mocking is supported");
        }
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath(url.getPath());
        MockitoSpringConfiguration configuration = new MockitoSpringConfiguration(serviceInterfaces, contextBeans);
        webAppContext.setConfigurations(new Configuration[]{configuration});
        webAppContext.setParentLoaderPriority(true);
        Server server = new Server(url.getPort());
        server.setHandler((Handler)webAppContext);
        this.servers.add(server);
        server.start();
        return configuration.getAll();
    }

    public <T> T mock(Class<T> serviceInterface, String baseAddress) throws Exception {
        return this.mock(serviceInterface, this.defaultContextBeans, baseAddress, null);
    }

    public <T> T mock(Class<T> serviceInterface, String baseAddress, String path) throws Exception {
        return this.mock(serviceInterface, this.defaultContextBeans, baseAddress, path);
    }

    public <T> T mock(Class<T> serviceInterface, List<Class<?>> contextBeans, String baseAddress, String path) throws Exception {
        if (path != null || serviceInterface.isInterface()) {
            serviceInterface = RestServiceRule.asService(serviceInterface, path);
        }
        ArrayList mockTargetBeans = new ArrayList();
        mockTargetBeans.add(serviceInterface);
        Map<Class<?>, Object> mock = this.mock(mockTargetBeans, contextBeans, baseAddress);
        return (T)mock.get(serviceInterface);
    }

    protected void before() throws Throwable {
        super.before();
    }

    protected void after() {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() throws Exception {
        for (Server endpointImpl : this.servers) {
            endpointImpl.stop();
        }
    }

    public void stop() throws Exception {
        for (Server endpointImpl : this.servers) {
            endpointImpl.stop();
        }
    }

    public void start() throws Exception {
        for (Server endpointImpl : this.servers) {
            endpointImpl.start();
        }
    }

    public Builder builder(String address) {
        return new Builder(address);
    }

    static /* synthetic */ List access$000(RestServiceRule x0) {
        return x0.defaultContextBeans;
    }

    public class Builder {
        private String address;
        private List<Class<?>> beans = new ArrayList();
        private List<Class<?>> contextBeans = new ArrayList(RestServiceRule.access$000(RestServiceRule.this));

        public Builder(String address) {
            this.address = address;
        }

        public <T> T mock() throws Exception {
            if (this.beans.isEmpty()) {
                throw new IllegalArgumentException("No beans added");
            }
            if (this.beans.size() == 1) {
                return (T)RestServiceRule.this.mock(this.beans.get(0), this.address);
            }
            return (T)RestServiceRule.this.mock(this.beans, this.address);
        }

        public Builder service(Class<?> serviceClass) throws Exception {
            return this.service(serviceClass, null);
        }

        public Builder service(Class<?> serviceInterface, String path) throws Exception {
            if (path != null || serviceInterface.isInterface()) {
                this.beans.add(RestServiceRule.asService(serviceInterface, path));
            } else {
                this.beans.add(serviceInterface);
            }
            return this;
        }

        public Builder context(Class<?> context) {
            this.contextBeans.add(context);
            return this;
        }
    }
}

