/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.rest.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class ResponseEntityMapper {
    private ObjectMapper mapper;

    public ResponseEntityMapper() {
        this(new ObjectMapper());
    }

    public ResponseEntityMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public <T> T unmarshall(String json, Class<T> cls) throws IOException {
        StringReader reader = new StringReader(json);
        return (T)this.mapper.readValue((Reader)reader, cls);
    }

    public String marshall(Object object, boolean prettyPrint) throws IOException {
        StringWriter writer = new StringWriter();
        if (prettyPrint) {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)writer, object);
        } else {
            this.mapper.writeValue((Writer)writer, object);
        }
        return writer.toString();
    }

    public ObjectNode toNode(Object object) {
        return (ObjectNode)this.mapper.valueToTree(object);
    }

    public String marshall(Object object) throws IOException {
        return this.marshall(object, false);
    }

    public <T> T unmarshallResource(String path, Class<T> cls) throws IOException {
        File file = this.getResourceFile(path);
        return this.unmarshallFile(file, cls);
    }

    private File getResourceFile(String path) throws IOException {
        URL directoryURL = this.getClass().getResource(path);
        if (directoryURL == null) {
            throw new FileNotFoundException(path);
        }
        try {
            return new File(directoryURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unmarshallFile(File file, Class<T> cls) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getCanonicalPath());
        }
        try (FileInputStream in = new FileInputStream(file);){
            Object object = this.mapper.readValue((Reader)new InputStreamReader((InputStream)in, Charset.forName("UTF-8")), cls);
            return (T)object;
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public <T> ResponseEntity<T> response(File file, Class<T> cls, Object ... headers) throws IOException {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON);
        if (headers != null) {
            if (headers.length % 2 != 0) {
                throw new IllegalArgumentException("Headers must be in key-value pairs");
            }
            for (int i = 0; i < headers.length; i += 2) {
                if (headers[i + 1] instanceof String) {
                    responseHeaders.put((String)headers[i], Arrays.asList((String)headers[i + 1]));
                    continue;
                }
                if (headers[i + 1] instanceof List) {
                    responseHeaders.put((String)headers[i], (List)headers[i + 1]);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected value " + headers[i + 1]);
            }
        }
        T t = this.unmarshallFile(file, cls);
        return new ResponseEntity(t, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public <T> ResponseEntity<T> response(String resource, Class<T> cls, Object ... headers) throws IOException {
        return this.response(this.getResourceFile(resource), cls, headers);
    }
}

