/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.rest.spring;

import com.github.skjolber.mockito.rest.spring.MockitoSpringFactoryWebApplicationContext;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class MockitoSpringContainerStarter
extends AbstractLifeCycle
implements ServletContextHandler.ServletContainerInitializerCaller {
    private WebAppContext context;
    private List<Class<?>> mockTargetBeans;
    private List<Class<?>> contextBeans;
    private ApplicationListener<ApplicationContextEvent> listener;

    public MockitoSpringContainerStarter(WebAppContext context, List<Class<?>> beans, List<Class<?>> configurationBeans, ApplicationListener<ApplicationContextEvent> listener) {
        this.context = context;
        this.mockTargetBeans = beans;
        this.contextBeans = configurationBeans;
        this.listener = listener;
    }

    public void doStart() {
        ContextHandler.Context container = this.context.getServletContext();
        container.setExtendedListenerTypes(true);
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        container.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)rootContext));
        MockitoSpringFactoryWebApplicationContext dispatcherContext = new MockitoSpringFactoryWebApplicationContext(this.mockTargetBeans);
        for (Class<?> bean : this.contextBeans) {
            dispatcherContext.register(new Class[]{bean});
        }
        dispatcherContext.addApplicationListener(this.listener);
        ServletRegistration.Dynamic dispatcher = container.addServlet("dispatcher", (Servlet)new DispatcherServlet((WebApplicationContext)dispatcherContext));
        dispatcher.setLoadOnStartup(1);
        dispatcher.addMapping(new String[]{"/"});
    }
}

