/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.helper.JavaProjectBuilderHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.openapi.OpenApiTag;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JsonUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OpenApiBuilder {
    static Map<String, String> stringComponent = new HashMap<String, String>(){
        {
            this.put("type", "string");
            this.put("format", "string");
        }
    };

    public static void buildOpenApi(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        OpenApiBuilder.openApiCreate(config, configBuilder);
    }

    public static void buildOpenApi(ApiConfig config, JavaProjectBuilder projectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, projectBuilder);
        OpenApiBuilder.openApiCreate(config, configBuilder);
    }

    private static void openApiCreate(ApiConfig config, ProjectDocConfigBuilder configBuilder) {
        config.setParamsDataToTree(true);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        HashMap<String, Object> json = new HashMap<String, Object>(8);
        json.put("openapi", "3.0.3");
        json.put("info", OpenApiBuilder.buildInfo(config));
        json.put("servers", OpenApiBuilder.buildServers(config));
        HashSet<OpenApiTag> tags = new HashSet<OpenApiTag>();
        json.put("tags", tags);
        json.put("paths", OpenApiBuilder.buildPaths(config, apiDocList, tags));
        json.put("components", OpenApiBuilder.buildComponentsSchema(apiDocList));
        String filePath = config.getOutPath();
        filePath = filePath + "/openapi.json";
        String data = JsonUtil.toPrettyJson(json);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static Map<String, Object> buildInfo(ApiConfig apiConfig) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        infoMap.put("title", apiConfig.getProjectName() == null ? "Project Name is Null." : apiConfig.getProjectName());
        infoMap.put("version", "1.0.0");
        return infoMap;
    }

    private static List<Map<String, Object>> buildServers(ApiConfig config) {
        ArrayList<Map<String, Object>> serverList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> serverMap = new HashMap<String, String>(8);
        serverMap.put("url", config.getServerUrl() == null ? "" : config.getServerUrl());
        serverList.add(serverMap);
        return serverList;
    }

    private static Map<String, Object> buildPaths(ApiConfig apiConfig, List<ApiDoc> apiDocList, Set<OpenApiTag> tags) {
        HashMap<String, Object> pathMap = new HashMap<String, Object>(500);
        apiDocList.forEach(a -> {
            tags.add(OpenApiTag.of(a.getDesc(), a.getDesc()));
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String url = method.getPath().replace("//", "/");
                Map<String, Object> request = OpenApiBuilder.buildPathUrls(apiConfig, method, a);
                if (!pathMap.containsKey(url)) {
                    pathMap.put(url, request);
                } else {
                    Map oldRequest = (Map)pathMap.get(url);
                    oldRequest.putAll(request);
                }
            });
        });
        return pathMap;
    }

    private static Map<String, Object> buildPathUrls(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(4);
        request.put(apiMethodDoc.getType().toLowerCase(), OpenApiBuilder.buildPathUrlsRequest(apiConfig, apiMethodDoc, apiDoc));
        return request;
    }

    private static Map<String, Object> buildPathUrlsRequest(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(20);
        request.put("summary", apiMethodDoc.getDesc());
        request.put("description", apiMethodDoc.getDetail());
        if (StringUtil.isNotEmpty((String)apiMethodDoc.getGroup())) {
            request.put("tags", new String[]{apiDoc.getDesc()});
        } else {
            request.put("tags", new String[]{apiDoc.getDesc()});
        }
        request.put("requestBody", OpenApiBuilder.buildRequestBody(apiConfig, apiMethodDoc));
        request.put("parameters", OpenApiBuilder.buildParameters(apiMethodDoc));
        request.put("responses", OpenApiBuilder.buildResponses(apiConfig, apiMethodDoc));
        request.put("deprecated", apiMethodDoc.isDeprecated());
        request.put("operationId", String.join((CharSequence)"", OpenApiSchemaUtil.getPatternResult("[A-Za-z0-9{}]*", apiMethodDoc.getPath())));
        return request;
    }

    private static Map<String, Object> buildRequestBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        boolean isPost;
        HashMap<String, Object> requestBody = new HashMap<String, Object>(8);
        boolean bl = isPost = apiMethodDoc.getType().equals(Methods.POST.getValue()) || apiMethodDoc.getType().equals(Methods.PUT.getValue()) || apiMethodDoc.getType().equals(Methods.PATCH.getValue());
        if (isPost) {
            requestBody.put("content", OpenApiBuilder.buildContent(apiConfig, apiMethodDoc, false));
            return requestBody;
        }
        return null;
    }

    private static Map<String, Object> buildContent(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        String contentType = apiMethodDoc.getContentType();
        if (isRep) {
            contentType = "*/*";
        }
        content.put(contentType, OpenApiBuilder.buildContentBody(apiConfig, apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildContentBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        if (Objects.nonNull(apiMethodDoc.getReturnSchema()) && isRep) {
            content.put("schema", apiMethodDoc.getReturnSchema());
        } else if (!isRep && Objects.nonNull(apiMethodDoc.getRequestSchema())) {
            content.put("schema", apiMethodDoc.getRequestSchema());
        } else {
            content.put("schema", OpenApiBuilder.buildBodySchema(apiMethodDoc, isRep));
        }
        if (!isRep && apiConfig.isRequestExample() || isRep && apiConfig.isResponseExample()) {
            content.put("examples", OpenApiBuilder.buildBodyExample(apiMethodDoc, isRep));
        }
        return content;
    }

    private static Map<String, Object> buildBodySchema(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        HashMap<String, String> innerScheme = new HashMap<String, String>(10);
        String requestRef = apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded;charset=UTF-8") ? "#/components/schemas/" + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getQueryParams()) : "#/components/schemas/" + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getRequestParams());
        String responseRef = "#/components/schemas/" + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getResponseParams());
        if (apiMethodDoc.isListParam()) {
            schema.put("type", "array");
            if (isRep) {
                innerScheme.put("$ref", responseRef);
            } else {
                innerScheme.put("$ref", requestRef);
            }
            schema.put("items", innerScheme);
        } else if (isRep && CollectionUtil.isNotEmpty(apiMethodDoc.getResponseParams())) {
            schema.put("$ref", responseRef);
        } else if (!isRep && (CollectionUtil.isNotEmpty(apiMethodDoc.getRequestParams()) || CollectionUtil.isNotEmpty(apiMethodDoc.getQueryParams()) && apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded;charset=UTF-8"))) {
            schema.put("$ref", requestRef);
        }
        return schema;
    }

    private static Map<String, Object> buildBodyExample(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("json", OpenApiBuilder.buildExampleData(apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildExampleData(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("summary", "test data");
        if (!isRep) {
            content.put("value", StringUtil.isEmpty((String)apiMethodDoc.getRequestExample().getJsonBody()) ? apiMethodDoc.getRequestExample().getExampleBody() : apiMethodDoc.getRequestExample().getJsonBody());
        } else {
            content.put("value", apiMethodDoc.getResponseUsage());
        }
        return content;
    }

    private static List<Map<String, Object>> buildParameters(ApiMethodDoc apiMethodDoc) {
        List<ApiParam> children;
        Map<String, Object> parameters;
        ArrayList<Map<String, Object>> parametersList = new ArrayList<Map<String, Object>>();
        for (ApiParam apiParam : apiMethodDoc.getPathParams()) {
            parameters = OpenApiBuilder.getStringParams(apiParam);
            parameters.put("in", "path");
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        if (!apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded;charset=UTF-8")) {
            for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
                parameters = OpenApiBuilder.getStringParams(apiParam);
                parameters.put("in", "query");
                children = apiParam.getChildren();
                if (!CollectionUtil.isEmpty(children)) continue;
                parametersList.add(parameters);
            }
        }
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestHeaders())) {
            for (ApiReqParam header : apiMethodDoc.getRequestHeaders()) {
                parameters = new HashMap<String, Object>(20);
                parameters.put("name", header.getName());
                parameters.put("description", header.getDesc());
                parameters.put("required", header.isRequired());
                parameters.put("example", header.getValue());
                parameters.put("schema", OpenApiBuilder.buildParametersSchema(header));
                parameters.put("in", "header");
                parametersList.add(parameters);
            }
        }
        return parametersList;
    }

    private static Map<String, Object> getStringParams(ApiParam apiParam) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(20);
        parameters.put("name", apiParam.getField());
        parameters.put("description", apiParam.getDesc());
        parameters.put("required", apiParam.isRequired());
        parameters.put("example", StringUtil.removeQuotes((String)apiParam.getValue()));
        parameters.put("schema", OpenApiBuilder.buildParametersSchema(apiParam));
        return parameters;
    }

    private static Map<String, Object> buildParametersSchema(ApiParam apiParam) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        schema.put("type", openApiType);
        if ("object".equals(openApiType) || "string".equals(openApiType)) {
            if ("file".equals(apiParam.getType())) {
                schema.put("format", "binary");
            } else if ("enum".equals(apiParam.getType())) {
                schema.put("enum", apiParam.getEnumValues());
            } else if ("array".equals(apiParam.getType())) {
                if (CollectionUtil.isNotEmpty(apiParam.getEnumValues())) {
                    schema.put("type", "string");
                    schema.put("items", apiParam.getEnumValues());
                } else {
                    schema.put("type", "array");
                    schema.put("items", new HashMap());
                }
            }
        } else {
            schema.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        return schema;
    }

    private static Map<String, Object> buildParametersSchema(ApiReqParam header) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(header.getType());
        schema.put("type", openApiType);
        schema.put("format", "int16".equals(header.getType()) ? "int32" : header.getType());
        return schema;
    }

    private static Map<String, Object> buildResponses(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> response = new HashMap<String, Object>(10);
        response.put("200", OpenApiBuilder.buildResponsesBody(apiConfig, apiMethodDoc));
        return response;
    }

    private static Map<String, Object> buildResponsesBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(10);
        responseBody.put("description", "OK");
        responseBody.put("content", OpenApiBuilder.buildContent(apiConfig, apiMethodDoc, true));
        return responseBody;
    }

    private static Map<String, Object> buildComponentsSchema(List<ApiDoc> apiDocs) {
        HashMap<String, Object> schemas = new HashMap<String, Object>(4);
        HashMap<String, Map<String, String>> component = new HashMap<String, Map<String, String>>();
        component.put("string", stringComponent);
        apiDocs.forEach(a -> {
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String requestSchema = OpenApiSchemaUtil.getClassNameFromParams(method.getRequestParams());
                List<ApiParam> requestParams = method.getRequestParams();
                Map<String, Object> prop = OpenApiBuilder.buildProperties(requestParams, component);
                component.put(requestSchema, prop);
                List<ApiParam> responseParams = method.getResponseParams();
                String schemaName = OpenApiSchemaUtil.getClassNameFromParams(method.getResponseParams());
                component.put(schemaName, OpenApiBuilder.buildProperties(responseParams, component));
            });
        });
        component.remove("NO_BODY_PARAM");
        schemas.put("schemas", component);
        return schemas;
    }

    private static Map<String, Object> buildProperties(List<ApiParam> apiParam, Map<String, Object> component) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> propertiesData = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> requiredList = new ArrayList<String>();
        if (apiParam != null) {
            int paramsSize = apiParam.size();
            for (ApiParam param : apiParam) {
                if (param.isRequired()) {
                    requiredList.add(param.getField());
                }
                if (param.getType().equals("map") && paramsSize == 1 || param.isQueryParam() || param.isPathParam()) continue;
                String field = param.getField();
                propertiesData.put(field, OpenApiBuilder.buildPropertiesData(param, component));
            }
            if (!propertiesData.isEmpty()) {
                properties.put("properties", propertiesData);
            }
            if (!CollectionUtil.isEmpty(requiredList)) {
                properties.put("required", requiredList);
            }
            return properties;
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> buildPropertiesData(ApiParam apiParam, Map<String, Object> component) {
        HashMap<String, Object> propertiesData = new HashMap<String, Object>();
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        propertiesData.put("description", apiParam.getDesc());
        if (!"object".equals(openApiType)) {
            propertiesData.put("type", openApiType);
            propertiesData.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        if ("map".equals(apiParam.getType())) {
            propertiesData.put("type", "object");
            propertiesData.put("description", apiParam.getDesc() + "(map data)");
        }
        if ("array".equals(apiParam.getType()) && CollectionUtil.isNotEmpty(apiParam.getChildren())) {
            propertiesData.put("type", "array");
            if (!apiParam.isSelfReferenceLoop()) {
                HashMap<String, String> arrayRef = new HashMap<String, String>(4);
                String childSchemaName = OpenApiSchemaUtil.getClassNameFromParams(apiParam.getChildren());
                if (childSchemaName.contains("NO_BODY_PARAM")) {
                    propertiesData.put("type", "object");
                    propertiesData.put("description", apiParam.getDesc() + "(object)");
                } else {
                    component.put(childSchemaName, OpenApiBuilder.buildProperties(apiParam.getChildren(), component));
                    arrayRef.put("$ref", "#/components/schemas/" + childSchemaName);
                    propertiesData.put("items", arrayRef);
                }
            }
        }
        if ("file".equals(apiParam.getType())) {
            propertiesData.put("type", "string");
            propertiesData.put("format", "binary");
        }
        if ("object".equals(apiParam.getType())) {
            if (CollectionUtil.isNotEmpty(apiParam.getChildren())) {
                propertiesData.put("type", "object");
                propertiesData.put("description", apiParam.getDesc() + "(object)");
                if (!apiParam.isSelfReferenceLoop()) {
                    String childSchemaName = OpenApiSchemaUtil.getClassNameFromParams(apiParam.getChildren());
                    if (childSchemaName.contains("NO_BODY_PARAM")) {
                        propertiesData.put("type", "object");
                        propertiesData.put("description", apiParam.getDesc() + "(object)");
                    } else {
                        component.put(childSchemaName, OpenApiBuilder.buildProperties(apiParam.getChildren(), component));
                        propertiesData.put("$ref", "#/components/schemas/" + childSchemaName);
                    }
                }
            } else {
                propertiesData.put("type", "object");
                propertiesData.put("description", apiParam.getDesc() + "(object)");
            }
        }
        return propertiesData;
    }
}

