/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MultipleStringLiteralsExtendedCheck
extends AbstractCheck {
    public static final String MSG_KEY = "multiple.string.literal";
    private final Map<String, List<DetailAST>> stringMap = new HashMap<String, List<DetailAST>>();
    private final BitSet ignoreOccurrenceContext = new BitSet();
    private int allowedDuplicates = 1;
    private boolean highlightAllDuplicates;
    private Pattern pattern;

    public MultipleStringLiteralsExtendedCheck() {
        this.setIgnoreStringsRegexp("^\"\"$");
        this.ignoreOccurrenceContext.set(159);
    }

    public void setAllowedDuplicates(int allowedDuplicates) {
        this.allowedDuplicates = allowedDuplicates;
    }

    public final void setIgnoreStringsRegexp(String ignoreStringsRegexp) {
        this.pattern = ignoreStringsRegexp != null && ignoreStringsRegexp.length() > 0 ? Pattern.compile(ignoreStringsRegexp) : null;
    }

    public final void setHighlightAllDuplicates(boolean highlightAllDuplicates) {
        this.highlightAllDuplicates = highlightAllDuplicates;
    }

    public final void setIgnoreOccurrenceContext(String ... strRep) {
        this.ignoreOccurrenceContext.clear();
        for (String s : strRep) {
            int type = TokenUtil.getTokenId((String)s);
            this.ignoreOccurrenceContext.set(type);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{139};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (!this.isInIgnoreOccurrenceContext(ast)) {
            String currentString = ast.getText();
            if (this.pattern == null || !this.pattern.matcher(currentString).find()) {
                this.stringMap.computeIfAbsent(currentString, key -> new ArrayList()).add(ast);
            }
        }
    }

    private boolean isInIgnoreOccurrenceContext(DetailAST ast) {
        boolean result = false;
        for (DetailAST token = ast.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (!this.ignoreOccurrenceContext.get(type)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void beginTree(DetailAST rootAST) {
        super.beginTree(rootAST);
        this.stringMap.clear();
    }

    public void finishTree(DetailAST rootAST) {
        Set<String> keys = this.stringMap.keySet();
        for (String key : keys) {
            List<DetailAST> hits = this.stringMap.get(key);
            if (hits.size() <= this.allowedDuplicates) continue;
            int hitsSize = 1;
            if (this.highlightAllDuplicates) {
                hitsSize = hits.size();
            }
            for (int index = 0; index < hitsSize; ++index) {
                DetailAST firstFinding = hits.get(index);
                this.log(firstFinding, MSG_KEY, new Object[]{key, hits.size()});
            }
        }
    }
}

