/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class LogicConditionNeedOptimizationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "logic.condition.need.optimization";
    private static final int THIRD_POSITION = 3;
    private static final int OPERAND_SIZE = 4;

    public int[] getDefaultTokens() {
        return new int[]{111, 110};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST detailAST) {
        if (LogicConditionNeedOptimizationCheck.needOptimization(detailAST)) {
            this.log(detailAST, MSG_KEY, new Object[]{detailAST.getText(), detailAST.getLineNo(), detailAST.getColumnNo()});
        }
    }

    private static boolean needOptimization(DetailAST logicNode) {
        DetailAST[] operands = LogicConditionNeedOptimizationCheck.getOperands(logicNode);
        boolean firstInstanceOf = LogicConditionNeedOptimizationCheck.branchContains(operands, 1, 121);
        boolean secondTypeCast = LogicConditionNeedOptimizationCheck.branchContains(operands, 2, 23);
        boolean result = firstInstanceOf && secondTypeCast ? false : !LogicConditionNeedOptimizationCheck.branchContains(operands, 2, 27) && !LogicConditionNeedOptimizationCheck.branchContains(operands, 2, 121) && (firstInstanceOf || LogicConditionNeedOptimizationCheck.branchContains(operands, 1, 27));
        return result;
    }

    private static DetailAST[] getOperands(DetailAST logicNode) {
        DetailAST node;
        DetailAST[] results = new DetailAST[4];
        results[0] = node = logicNode.getFirstChild();
        int parenthesis = 0;
        do {
            if (node.getType() == 76 && node.getFirstChild() == null) {
                ++parenthesis;
            } else {
                if (node.getType() == 77) {
                    --parenthesis;
                }
                if (parenthesis == 0) {
                    results[1] = node;
                }
            }
            node = node.getNextSibling();
        } while (parenthesis > 0);
        results[2] = node;
        results[3] = logicNode.getLastChild();
        return results;
    }

    private static boolean branchContains(DetailAST[] operands, int setNumber, int type) {
        boolean result = setNumber == 1 ? LogicConditionNeedOptimizationCheck.branchContains(operands[0], operands[1], type) : LogicConditionNeedOptimizationCheck.branchContains(operands[2], operands[3], type);
        return result;
    }

    private static boolean branchContains(DetailAST start, DetailAST end, int type) {
        boolean result;
        DetailAST current = start;
        while (true) {
            result = current.branchContains(type);
            if (current == end || result) break;
            current = current.getNextSibling();
        }
        return result;
    }
}

