/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.annotation;

import com.google.common.base.CharMatcher;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForbidAnnotationElementValueCheck
extends AbstractCheck {
    public static final String MSG_KEY = "annotation.forbid.element.value";
    private static final CharMatcher QUOTE_MATCHER = CharMatcher.is((char)'\"');
    private static final String ELEMENT_NAME_DEFAULT = "value";
    private String annotationName = "Test";
    private String elementName = "expected";
    private Pattern forbiddenElementValueRegexp = Pattern.compile(".*");

    public void setAnnotationName(String annotationName) {
        this.annotationName = annotationName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setForbiddenElementValueRegexp(String forbiddenElementValueRegexp) {
        this.forbiddenElementValueRegexp = Pattern.compile(forbiddenElementValueRegexp);
    }

    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (ForbidAnnotationElementValueCheck.getAnnotationName(ast).equals(this.annotationName)) {
            if (ELEMENT_NAME_DEFAULT.equals(this.elementName) && this.isSingleElementAnnotation(ast)) {
                DetailAST forbiddenElement = this.getSingleElementWithForbiddenValue(ast);
                this.log(forbiddenElement, MSG_KEY, new Object[]{this.elementName, this.annotationName});
            } else {
                for (DetailAST forbiddenElement : this.getForbiddenElements(ast)) {
                    this.log(forbiddenElement, MSG_KEY, new Object[]{this.elementName, this.annotationName});
                }
            }
        }
    }

    private boolean isSingleElementAnnotation(DetailAST annotation) {
        return this.getSingleElementWithForbiddenValue(annotation) != null;
    }

    private DetailAST getSingleElementWithForbiddenValue(DetailAST annotation) {
        DetailAST singleElement = null;
        for (DetailAST currentNode = annotation.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            String elementValue;
            if (currentNode.getType() != 28 && currentNode.getType() != 162 || !this.forbiddenElementValueRegexp.matcher(elementValue = ForbidAnnotationElementValueCheck.getSingleElementValue(currentNode)).find()) continue;
            singleElement = currentNode;
            break;
        }
        return singleElement;
    }

    private List<DetailAST> getForbiddenElements(DetailAST annotation) {
        LinkedList<DetailAST> forbiddenElements = new LinkedList<DetailAST>();
        for (DetailAST currentNode = annotation.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getType() != 160 || !this.isElementForbidden(currentNode)) continue;
            forbiddenElements.add(currentNode);
        }
        return forbiddenElements;
    }

    private boolean isElementForbidden(DetailAST memberValuePair) {
        String elementValue = ForbidAnnotationElementValueCheck.getElementValue(memberValuePair);
        Matcher elementValueMatcher = this.forbiddenElementValueRegexp.matcher(elementValue);
        return ForbidAnnotationElementValueCheck.getElementName(memberValuePair).equals(this.elementName) && elementValueMatcher.find();
    }

    private static String getElementValue(DetailAST memberValuePair) {
        String elementValue;
        DetailAST elementValueAst = memberValuePair.findFirstToken(28);
        if (elementValueAst == null) {
            elementValueAst = memberValuePair.findFirstToken(162);
            elementValue = ForbidAnnotationElementValueCheck.getListOfValuesAsText(elementValueAst);
        } else {
            elementValue = ForbidAnnotationElementValueCheck.getExpressionText(elementValueAst);
        }
        return elementValue;
    }

    private static String getSingleElementValue(DetailAST parameter) {
        String parameterValue = parameter.getType() == 28 ? ForbidAnnotationElementValueCheck.getExpressionText(parameter) : ForbidAnnotationElementValueCheck.getListOfValuesAsText(parameter);
        return parameterValue;
    }

    private static String getExpressionText(DetailAST expression) {
        String elementValue;
        DetailAST expressionValue = expression.getFirstChild();
        if (expressionValue.getType() == 59) {
            FullIdent fullExpression = FullIdent.createFullIdent((DetailAST)expressionValue);
            elementValue = fullExpression.getText();
        } else {
            elementValue = expressionValue.getText();
        }
        return ForbidAnnotationElementValueCheck.trimQuotes(elementValue);
    }

    private static String getListOfValuesAsText(DetailAST brace) {
        Object fullText = "{";
        for (DetailAST currentNode = brace.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            fullText = currentNode.getType() == 28 ? (String)fullText + currentNode.getFirstChild().getText() : (String)fullText + currentNode.getText();
        }
        return fullText;
    }

    private static String trimQuotes(String input) {
        return QUOTE_MATCHER.trimFrom((CharSequence)input);
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST annotationName = annotation.findFirstToken(58);
        if (annotationName == null) {
            annotationName = annotation.findFirstToken(59).getLastChild();
        }
        return annotationName.getText();
    }

    private static String getElementName(DetailAST memberValuePair) {
        DetailAST elementName = memberValuePair.findFirstToken(58);
        return elementName.getText();
    }
}

