/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.util;

import com.github.sd4324530.fastweixin.util.BeanUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StreamUtil.class);

    private StreamUtil() {
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead1;
        BeanUtil.requireNonNull(in, "No InputStream specified");
        BeanUtil.requireNonNull(out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((bytesRead1 = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead1);
            byteCount += bytesRead1;
        }
        out.flush();
        return byteCount;
    }

    public static void closeWithWarn(Closeable closeable) {
        if (BeanUtil.nonNull(closeable)) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.warn("\u5173\u95ed\u6d41\u51fa\u9519......", (Throwable)e);
            }
        }
    }
}

