/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.util;

import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SignUtil.class);
    private static final char[] digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private SignUtil() {
    }

    public static boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        if (StrUtil.hasBlank(token, signature, timestamp, nonce)) {
            return false;
        }
        Object[] arr = new String[]{token, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (Object anArr : arr) {
            content.append((String)anArr);
        }
        String tmpStr = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes("UTF-8"));
            tmpStr = SignUtil.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("\u52a0\u5bc6\u65b9\u5f0f\u5f02\u5e38", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("\u7f16\u7801\u683c\u5f0f\u4e0d\u652f\u6301", (Throwable)e);
        }
        return tmpStr != null && tmpStr.equalsIgnoreCase(signature);
    }

    private static String byteToStr(byte[] byteArray) {
        int len = byteArray.length;
        StringBuilder strDigest = new StringBuilder(len * 2);
        for (byte aByteArray : byteArray) {
            strDigest.append(SignUtil.byteToHexStr(aByteArray));
        }
        return strDigest.toString();
    }

    private static String byteToHexStr(byte mByte) {
        char[] tempArr = new char[]{digit[mByte >>> 4 & 0xF], digit[mByte & 0xF]};
        return new String(tempArr);
    }
}

