/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.util;

import com.github.sd4324530.fastweixin.message.aes.WXBizMsgCrypt;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import com.github.sd4324530.fastweixin.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class MessageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MessageUtil.class);
    private static final String FORMAT = "<xml><ToUserName><![CDATA[toUser]]></ToUserName><Encrypt><![CDATA[%1$s]]></Encrypt></xml>";

    private MessageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> parseXml(HttpServletRequest request, String token, String appId, String aesKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object inputStream = null;
        try {
            inputStream = request.getInputStream();
            if (StrUtil.isNotBlank(aesKey)) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                StreamUtil.copy((InputStream)inputStream, outputStream);
                String body = outputStream.toString();
                LOG.debug("\u6536\u5230\u7684\u6d88\u606f\u5bc6\u6587:{}", (Object)body);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                StringReader sr = new StringReader(body);
                InputSource is = new InputSource(sr);
                Document document = db.parse(is);
                Element root = document.getDocumentElement();
                NodeList nodelist1 = root.getElementsByTagName("Encrypt");
                WXBizMsgCrypt pc = new WXBizMsgCrypt(token, aesKey, appId);
                String msgSignature = request.getParameter("msg_signature");
                String timeStamp = request.getParameter("timestamp");
                String nonce = request.getParameter("nonce");
                LOG.debug("msgSignature:{}", (Object)msgSignature);
                LOG.debug("timeStamp:{}", (Object)timeStamp);
                LOG.debug("nonce:{}", (Object)nonce);
                String encrypt = nodelist1.item(0).getTextContent();
                String fromXML = String.format(FORMAT, encrypt);
                String message = pc.decryptMsg(msgSignature, timeStamp, nonce, fromXML);
                inputStream = new ByteArrayInputStream(message.getBytes());
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader((InputStream)inputStream);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement()) continue;
                String tagName = event.asStartElement().getName().toString();
                if ("SendPicsInfo".equals(tagName)) {
                    map.put(tagName, MessageUtil.eventSendPicsInfo(reader));
                    continue;
                }
                if ("SendLocationInfo".equals(tagName)) {
                    map.put(tagName, MessageUtil.eventSendLocationInfo(reader));
                    continue;
                }
                if ("ScanCodeInfo".equals(tagName)) {
                    map.put(tagName, MessageUtil.eventScanCodePush(reader));
                    continue;
                }
                if ("xml".equals(tagName)) continue;
                map.put(tagName, reader.getElementText());
            }
        }
        catch (IOException e) {
            LOG.error("IO\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        catch (XMLStreamException e) {
            LOG.error("XML\u89e3\u6790\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("\u5176\u4ed6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOG.error("IO\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        return map;
    }

    protected static Map<String, Object> eventSendPicsInfo(XMLEventReader reader) throws XMLStreamException {
        HashMap<String, Object> sendPicsInfoMap = new HashMap<String, Object>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            String tagName = event.asStartElement().getName().toString();
            if ("Count".equals(tagName)) {
                sendPicsInfoMap.put(tagName, reader.getElementText());
                continue;
            }
            if (!"PicList".equals(tagName)) continue;
            ArrayList picList = CollectionUtil.newArrayList();
            while (reader.hasNext()) {
                XMLEvent event1 = reader.nextEvent();
                if (event1.isStartElement() && "PicMd5Sum".equals(event1.asStartElement().getName().toString())) {
                    HashMap<String, String> picMap = new HashMap<String, String>();
                    picMap.put("PicMd5Sum", reader.getElementText());
                    picList.add(picMap);
                    continue;
                }
                if (!event1.isEndElement() || !"PicList".equals(event1.asEndElement().getName().toString())) continue;
                break;
            }
            sendPicsInfoMap.put(tagName, picList);
        }
        return sendPicsInfoMap;
    }

    protected static Map<String, Object> eventSendLocationInfo(XMLEventReader reader) throws XMLStreamException {
        HashMap<String, Object> sendLocationInfo = new HashMap<String, Object>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            String tagName = event.asStartElement().getName().toString();
            sendLocationInfo.put(tagName, reader.getElementText());
        }
        return sendLocationInfo;
    }

    protected static Map<String, Object> eventScanCodePush(XMLEventReader reader) throws XMLStreamException {
        HashMap<String, Object> scanCodePush = new HashMap<String, Object>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            String tagName = event.asStartElement().getName().toString();
            scanCodePush.put(tagName, reader.getElementText());
        }
        return scanCodePush;
    }
}

