/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.servlet;

import com.github.sd4324530.fastweixin.company.handle.QYEventHandle;
import com.github.sd4324530.fastweixin.company.handle.QYMessageHandle;
import com.github.sd4324530.fastweixin.company.message.req.QYBaseEvent;
import com.github.sd4324530.fastweixin.company.message.req.QYBaseReq;
import com.github.sd4324530.fastweixin.company.message.req.QYBaseReqMsg;
import com.github.sd4324530.fastweixin.company.message.req.QYBatchJobEvent;
import com.github.sd4324530.fastweixin.company.message.req.QYEnterAgentEvent;
import com.github.sd4324530.fastweixin.company.message.req.QYImageReqMsg;
import com.github.sd4324530.fastweixin.company.message.req.QYLocationEvent;
import com.github.sd4324530.fastweixin.company.message.req.QYLocationReqMsg;
import com.github.sd4324530.fastweixin.company.message.req.QYMenuEvent;
import com.github.sd4324530.fastweixin.company.message.req.QYScanCodeEvent;
import com.github.sd4324530.fastweixin.company.message.req.QYSendPicInfoEvent;
import com.github.sd4324530.fastweixin.company.message.req.QYTextReqMsg;
import com.github.sd4324530.fastweixin.company.message.req.QYVideoReqMsg;
import com.github.sd4324530.fastweixin.company.message.req.QYVoiceReqMsg;
import com.github.sd4324530.fastweixin.company.message.resp.QYBaseRespMsg;
import com.github.sd4324530.fastweixin.company.message.resp.QYTextRespMsg;
import com.github.sd4324530.fastweixin.message.aes.AesException;
import com.github.sd4324530.fastweixin.message.aes.WXBizMsgCrypt;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.MessageUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QYWeixinSupport {
    private static final Logger LOG = LoggerFactory.getLogger(QYWeixinSupport.class);
    private static final Object LOCK = new Object();
    private static List<QYMessageHandle> messageHandles;
    private static List<QYEventHandle> eventHandles;

    protected abstract String getToken();

    protected abstract String getCropId();

    protected abstract String getAESKey();

    protected List<QYMessageHandle> initMessageHandles() {
        return null;
    }

    protected List<QYEventHandle> initEventHandles() {
        return null;
    }

    public void bindServer(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter pw = null;
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StrUtil.isBlank(this.getToken()) || StrUtil.isBlank(this.getAESKey()) || StrUtil.isBlank(this.getCropId())) {
            pw.write("");
            pw.flush();
            pw.close();
        }
        try {
            WXBizMsgCrypt pc = new WXBizMsgCrypt(this.getToken(), this.getAESKey(), this.getCropId());
            String echoStr = pc.verifyUrl(request.getParameter("msg_signature"), request.getParameter("timestamp"), request.getParameter("nonce"), request.getParameter("echostr"));
            pw.write(echoStr);
            pw.flush();
            pw.close();
        }
        catch (AesException e) {
            e.printStackTrace();
            pw.write("");
            pw.flush();
            pw.close();
        }
    }

    public String processRequest(HttpServletRequest request) {
        Map<String, Object> reqMap = MessageUtil.parseXml(request, this.getToken(), this.getCropId(), this.getAESKey());
        String fromUserName = (String)reqMap.get("FromUserName");
        String toUserName = (String)reqMap.get("ToUserName");
        String msgType = (String)reqMap.get("MsgType");
        LOG.debug("\u6536\u5230\u6d88\u606f\uff0c\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)msgType);
        QYBaseRespMsg msg = null;
        if (msgType.equals("event")) {
            String eventType = (String)reqMap.get("Event");
            LOG.debug("\u6536\u5230\u6d88\u606f\uff0c\u4e8b\u4ef6\u7c7b\u578b\uff1a{} ", (Object)eventType);
            if ("subscribe".equalsIgnoreCase(eventType)) {
                QYBaseEvent event = new QYBaseEvent();
                this.buildBasicEvent(reqMap, event);
                msg = this.handleSubScribe(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("unsubscribe".equalsIgnoreCase(eventType)) {
                QYBaseEvent event = new QYBaseEvent();
                this.buildBasicEvent(reqMap, event);
                msg = this.handleUnsubscribe(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("CLICK".equalsIgnoreCase(eventType)) {
                String eventKey = (String)reqMap.get("EventKey");
                LOG.debug("eventKey:{}", (Object)eventKey);
                QYMenuEvent event = new QYMenuEvent(eventKey);
                this.buildBasicEvent(reqMap, event);
                msg = this.handleMenuClickEvent(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("VIEW".equalsIgnoreCase(eventType)) {
                String eventKey = (String)reqMap.get("EventKey");
                LOG.debug("eventKey:{}", (Object)eventKey);
                QYMenuEvent event = new QYMenuEvent(eventKey);
                this.buildBasicEvent(reqMap, event);
                msg = this.handleMenuViewEvent(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("LOCATION".equalsIgnoreCase(eventType)) {
                double latitude = Double.parseDouble((String)reqMap.get("Latitude"));
                double longitude = Double.parseDouble((String)reqMap.get("Longitude"));
                double precision = Double.parseDouble((String)reqMap.get("Precision"));
                QYLocationEvent event = new QYLocationEvent(latitude, longitude, precision);
                this.buildBasicEvent(reqMap, event);
                msg = this.handleLocationEvent(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("scancode_push".equalsIgnoreCase(eventType) || "scancode_waitmsg".equalsIgnoreCase(eventType)) {
                String eventKey = (String)reqMap.get("EventKey");
                Map scanCodeInfo = (Map)reqMap.get("ScanCodeInfo");
                String scanType = (String)scanCodeInfo.get("ScanType");
                String scanResult = (String)scanCodeInfo.get("ScanResult");
                QYScanCodeEvent event = new QYScanCodeEvent(eventKey, scanType, scanResult);
                this.buildBasicEvent(reqMap, event);
                msg = this.handleScanCodeEvent(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("pic_photo_or_album".equalsIgnoreCase(eventType) || "pic_sysphoto".equalsIgnoreCase(eventType) || "pic_weixin".equalsIgnoreCase(eventType)) {
                String eventKey = (String)reqMap.get("EventKey");
                Map sendPicsInfo = (Map)reqMap.get("SendPicsInfo");
                int count = Integer.parseInt((String)sendPicsInfo.get("Count"));
                List picList = (List)sendPicsInfo.get("PicList");
                QYSendPicInfoEvent event = new QYSendPicInfoEvent(eventKey, count, picList);
                this.buildBasicEvent(reqMap, event);
                msg = this.handleSendPicsInfoEvent(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("enter_agent".equalsIgnoreCase(eventType)) {
                QYEnterAgentEvent event = new QYEnterAgentEvent();
                this.buildBasicEvent(reqMap, event);
                msg = this.handleEnterAgentEvent(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if ("batch_job_result".equalsIgnoreCase(eventType)) {
                Map batchJob = (Map)reqMap.get("BatchJob");
                String jobId = (String)batchJob.get("JobId");
                String jobType = (String)batchJob.get("JobType");
                int errCode = (Integer)batchJob.get("ErrCode");
                String errMsg = (String)batchJob.get("ErrMsg");
                QYBatchJobEvent event = new QYBatchJobEvent(jobId, jobType, errCode, errMsg);
                this.buildBasicEvent(reqMap, event);
                msg = this.handleBatchJobEvent(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            }
        } else if ("text".equalsIgnoreCase(msgType)) {
            String content = (String)reqMap.get("Content");
            LOG.debug("\u6587\u672c\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)content);
            QYTextReqMsg textReqMsg = new QYTextReqMsg(content);
            this.buildBasicReqMsg(reqMap, textReqMsg);
            msg = this.handleTextMsg(textReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(textReqMsg);
            }
        } else if ("image".equalsIgnoreCase(msgType)) {
            String picUrl = (String)reqMap.get("PicUrl");
            String mediaId = (String)reqMap.get("MediaId");
            QYImageReqMsg imageReqMsg = new QYImageReqMsg(picUrl, mediaId);
            this.buildBasicReqMsg(reqMap, imageReqMsg);
            msg = this.handleImageMsg(imageReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(imageReqMsg);
            }
        } else if ("voice".equalsIgnoreCase(msgType)) {
            String format = (String)reqMap.get("Format");
            String mediaId = (String)reqMap.get("MediaId");
            QYVoiceReqMsg voiceReqMsg = new QYVoiceReqMsg(mediaId, format);
            this.buildBasicReqMsg(reqMap, voiceReqMsg);
            msg = this.handleVoiceMsg(voiceReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(voiceReqMsg);
            }
        } else if ("video".equalsIgnoreCase(msgType)) {
            String thumbMediaId = (String)reqMap.get("ThumbMediaId");
            String mediaId = (String)reqMap.get("MediaId");
            QYVideoReqMsg videoReqMsg = new QYVideoReqMsg(mediaId, thumbMediaId);
            this.buildBasicReqMsg(reqMap, videoReqMsg);
            msg = this.handleVideoMsg(videoReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(videoReqMsg);
            }
        } else if ("shortvideo".equalsIgnoreCase(msgType)) {
            String thumbMediaId = (String)reqMap.get("ThumbMediaId");
            String mediaId = (String)reqMap.get("MediaId");
            QYVideoReqMsg videoReqMsg = new QYVideoReqMsg(mediaId, thumbMediaId);
            this.buildBasicReqMsg(reqMap, videoReqMsg);
            msg = this.handleShortVideoMsg(videoReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(videoReqMsg);
            }
        } else if ("location".equalsIgnoreCase(msgType)) {
            double locationX = Double.parseDouble((String)reqMap.get("Location_X"));
            double locationY = Double.parseDouble((String)reqMap.get("Location_Y"));
            int scale = Integer.parseInt((String)reqMap.get("Scale"));
            String label = (String)reqMap.get("Label");
            QYLocationReqMsg locationReqMsg = new QYLocationReqMsg(locationX, locationY, scale, label);
            this.buildBasicReqMsg(reqMap, locationReqMsg);
            msg = this.handleLocationMsg(locationReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(locationReqMsg);
            }
        }
        String result = "";
        if (BeanUtil.nonNull(msg)) {
            msg.setFromUserName(toUserName);
            msg.setToUserName(fromUserName);
            result = msg.toXml();
            try {
                WXBizMsgCrypt pc = new WXBizMsgCrypt(this.getToken(), this.getAESKey(), this.getCropId());
                result = pc.encryptMsg(result, request.getParameter("timestamp"), request.getParameter("nonce"));
                LOG.debug("\u52a0\u5bc6\u540e\u5bc6\u6587\uff1a{}", (Object)result);
            }
            catch (AesException e) {
                LOG.error("\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QYBaseRespMsg processMessageHandle(QYBaseReqMsg msg) {
        if (CollectionUtil.isEmpty(messageHandles)) {
            Object object = LOCK;
            synchronized (object) {
                messageHandles = this.initMessageHandles();
            }
        }
        if (CollectionUtil.isNotEmpty(messageHandles)) {
            for (QYMessageHandle messageHandle : messageHandles) {
                boolean result;
                QYBaseRespMsg resultMsg = null;
                try {
                    result = messageHandle.beforeHandle(msg);
                }
                catch (Exception e) {
                    result = false;
                }
                if (result) {
                    resultMsg = messageHandle.handle(msg);
                }
                if (!BeanUtil.nonNull(resultMsg)) continue;
                return resultMsg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QYBaseRespMsg processEventHandle(QYBaseEvent event) {
        if (CollectionUtil.isEmpty(eventHandles)) {
            Object object = LOCK;
            synchronized (object) {
                eventHandles = this.initEventHandles();
            }
        }
        if (CollectionUtil.isNotEmpty(eventHandles)) {
            for (QYEventHandle eventHandle : eventHandles) {
                boolean result;
                QYBaseRespMsg resultMsg = null;
                try {
                    result = eventHandle.beforeHandle(event);
                }
                catch (Exception e) {
                    result = false;
                }
                if (result) {
                    resultMsg = eventHandle.handle(event);
                }
                if (!BeanUtil.nonNull(resultMsg)) continue;
                return resultMsg;
            }
        }
        return null;
    }

    protected QYBaseRespMsg handleTextMsg(QYTextReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected QYBaseRespMsg handleImageMsg(QYImageReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected QYBaseRespMsg handleVoiceMsg(QYVoiceReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected QYBaseRespMsg handleVideoMsg(QYVideoReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected QYBaseRespMsg handleShortVideoMsg(QYVideoReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected QYBaseRespMsg handleLocationMsg(QYLocationReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected QYBaseRespMsg handleLocationEvent(QYLocationEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected QYBaseRespMsg handleMenuClickEvent(QYMenuEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected QYBaseRespMsg handleMenuViewEvent(QYMenuEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected QYBaseRespMsg handleScanCodeEvent(QYScanCodeEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected QYBaseRespMsg handleSendPicsInfoEvent(QYSendPicInfoEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected QYBaseRespMsg handleEnterAgentEvent(QYEnterAgentEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected QYBaseRespMsg handleBatchJobEvent(QYBatchJobEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected QYBaseRespMsg handleSubScribe(QYBaseEvent event) {
        return new QYTextRespMsg("\u611f\u8c22\u60a8\u7684\u5173\u6ce8");
    }

    protected QYBaseRespMsg handleUnsubscribe(QYBaseEvent event) {
        return null;
    }

    protected QYBaseRespMsg handleDefaultMsg(QYBaseReqMsg msg) {
        return null;
    }

    protected QYBaseRespMsg handleDefaultEvent(QYBaseEvent event) {
        return null;
    }

    private void buildBasicReqMsg(Map<String, Object> reqMap, QYBaseReqMsg reqMsg) {
        this.addBasicReqParams(reqMap, reqMsg);
        reqMsg.setMsgId((String)reqMap.get("MsgId"));
    }

    private void buildBasicEvent(Map<String, Object> reqMap, QYBaseEvent event) {
        this.addBasicReqParams(reqMap, event);
        event.setEvent((String)reqMap.get("Event"));
    }

    private void addBasicReqParams(Map<String, Object> reqMap, QYBaseReq req) {
        req.setMsgType((String)reqMap.get("MsgType"));
        req.setFromUserName((String)reqMap.get("FromUserName"));
        req.setToUserName((String)reqMap.get("ToUserName"));
        req.setCreateTime(Long.parseLong((String)reqMap.get("CreateTime")));
        req.setAgentId((String)reqMap.get("AgentID"));
    }
}

