/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.entity.Industry;
import com.github.sd4324530.fastweixin.api.entity.TemplateMsg;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.AddTemplateResponse;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.PrivateTemplate;
import com.github.sd4324530.fastweixin.api.response.SendTemplateResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateMsgAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateMsgAPI.class);

    public TemplateMsgAPI(ApiConfig config) {
        super(config);
    }

    public ResultType setIndustry(Industry industry) {
        LOG.debug("\u8bbe\u7f6e\u884c\u4e1a......");
        BeanUtil.requireNonNull(industry, "\u884c\u4e1a\u5bf9\u8c61\u4e3a\u7a7a");
        String url = "https://api.weixin.qq.com/cgi-bin/template/api_set_industry?access_token=#";
        BaseResponse response = this.executePost(url, industry.toJsonString());
        return ResultType.get(response.getErrcode());
    }

    public AddTemplateResponse addTemplate(String shortTemplateId) {
        LOG.debug("\u6dfb\u52a0\u6a21\u7248......");
        BeanUtil.requireNonNull(shortTemplateId, "\u77ed\u6a21\u7248id\u5fc5\u586b");
        String url = "https://api.weixin.qq.com/cgi-bin/template/api_add_template?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("template_id_short", shortTemplateId);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        AddTemplateResponse result = JSONUtil.toBean(resultJson, AddTemplateResponse.class);
        return result;
    }

    public SendTemplateResponse send(TemplateMsg msg) {
        LOG.debug("\u53d1\u9001\u6a21\u7248\u6d88\u606f......");
        BeanUtil.requireNonNull(msg.getTouser(), "openid is null");
        BeanUtil.requireNonNull(msg.getTemplateId(), "template_id is null");
        BeanUtil.requireNonNull(msg.getData(), "data is null");
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=#";
        BaseResponse r = this.executePost(url, msg.toJsonString());
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        SendTemplateResponse result = JSONUtil.toBean(resultJson, SendTemplateResponse.class);
        return result;
    }

    public PrivateTemplate[] getAllPrivateTemplate() {
        LOG.debug("\u83b7\u53d6\u5df2\u6dfb\u52a0\u81f3\u5e10\u53f7\u4e0b\u6240\u6709\u6a21\u677f\u5217\u8868......");
        String url = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=#";
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        PrivateTemplate[] templates = (PrivateTemplate[])JSONArray.toJavaObject((JSON)((JSONArray)JSONUtil.getJSONFromString(resultJson).get((Object)"template_list")), PrivateTemplate[].class);
        return templates;
    }

    public BaseResponse delTemplate(String templateId) {
        LOG.debug("\u5220\u9664\u6a21\u677f......");
        BeanUtil.requireNonNull(templateId, "templateId is null");
        String url = "https://api.weixin.qq.com/cgi-bin/template/del_private_template?access_token=#";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("template_id", templateId);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(map));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        return JSONUtil.toBean(resultJson, BaseResponse.class);
    }
}

