/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.entity.Menu;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.GetMenuResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MenuAPI.class);

    public MenuAPI(ApiConfig config) {
        super(config);
    }

    public ResultType createMenu(Menu menu) {
        BeanUtil.requireNonNull(menu, "menu is null");
        String url = "https://api.weixin.qq.com/";
        if (BeanUtil.isNull(menu.getMatchrule())) {
            LOG.debug("\u521b\u5efa\u666e\u901a\u83dc\u5355.....");
            url = url + "cgi-bin/menu/create?access_token=#";
        } else {
            LOG.debug("\u521b\u5efa\u4e2a\u6027\u5316\u83dc\u5355.....");
            url = url + "cgi-bin/menu/addconditional?access_token=#";
        }
        BaseResponse response = this.executePost(url, menu.toJsonString());
        return ResultType.get(response.getErrcode());
    }

    public GetMenuResponse getMenu() {
        GetMenuResponse response;
        LOG.debug("\u83b7\u53d6\u83dc\u5355\u4fe1\u606f.....");
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=#";
        BaseResponse r = this.executeGet(url);
        if (this.isSuccess(r.getErrcode())) {
            JSONObject jsonObject = JSONUtil.getJSONFromString(r.getErrmsg());
            List buttonList = (List)JSONPath.eval((Object)jsonObject, (String)"$.menu.button");
            if (CollectionUtil.isNotEmpty(buttonList)) {
                for (Object button : buttonList) {
                    List subList = (List)JSONPath.eval(button, (String)"$.sub_button");
                    if (CollectionUtil.isNotEmpty(subList)) {
                        for (Object sub : subList) {
                            Object type = JSONPath.eval(sub, (String)"$.type");
                            JSONPath.set(sub, (String)"$.type", (Object)type.toString().toUpperCase());
                        }
                        continue;
                    }
                    Object type = JSONPath.eval(button, (String)"$.type");
                    JSONPath.set(button, (String)"$.type", (Object)type.toString().toUpperCase());
                }
            }
            response = JSONUtil.toBean(jsonObject.toJSONString(), GetMenuResponse.class);
        } else {
            response = JSONUtil.toBean(r.toJsonString(), GetMenuResponse.class);
        }
        return response;
    }

    public ResultType deleteMenu() {
        LOG.debug("\u5220\u9664\u83dc\u5355.....");
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=#";
        BaseResponse response = this.executeGet(url);
        return ResultType.get(response.getErrcode());
    }

    public ResultType deleteConditionalMenu(String menuId) {
        BeanUtil.requireNonNull(menuId, "menuid is null");
        LOG.debug("\u5220\u9664\u4e2a\u6027\u5316\u83dc\u5355.....");
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delconditional?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("menuid", menuId);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(params));
        return ResultType.get(response.getErrcode());
    }

    public GetMenuResponse tryMatchMenu(String userId) {
        GetMenuResponse response;
        BeanUtil.requireNonNull(userId, "userId is null");
        LOG.debug("\u6d4b\u8bd5\u4e2a\u6027\u5316\u83dc\u5355.....");
        String url = "https://api.weixin.qq.com/cgi-bin/menu/trymatch?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", userId);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        if (this.isSuccess(r.getErrcode())) {
            JSONObject jsonObject = JSONUtil.getJSONFromString(r.getErrmsg());
            List buttonList = (List)JSONPath.eval((Object)jsonObject, (String)"$.menu.button");
            if (CollectionUtil.isNotEmpty(buttonList)) {
                for (Object button : buttonList) {
                    List subList = (List)JSONPath.eval(button, (String)"$.sub_button");
                    if (CollectionUtil.isNotEmpty(subList)) {
                        for (Object sub : subList) {
                            Object type = JSONPath.eval(sub, (String)"$.type");
                            JSONPath.set(sub, (String)"$.type", (Object)type.toString().toUpperCase());
                        }
                        continue;
                    }
                    Object type = JSONPath.eval(button, (String)"$.type");
                    JSONPath.set(button, (String)"$.type", (Object)type.toString().toUpperCase());
                }
            }
            response = JSONUtil.toBean(jsonObject.toJSONString(), GetMenuResponse.class);
        } else {
            response = JSONUtil.toBean(r.toJsonString(), GetMenuResponse.class);
        }
        return response;
    }
}

