/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.entity.Article;
import com.github.sd4324530.fastweixin.api.enums.MediaType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.DownloadMediaResponse;
import com.github.sd4324530.fastweixin.api.response.UploadImgResponse;
import com.github.sd4324530.fastweixin.api.response.UploadMediaResponse;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MediaAPI.class);

    public MediaAPI(ApiConfig config) {
        super(config);
    }

    public UploadMediaResponse uploadMedia(MediaType type, File file) {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=#&type=" + type.toString();
        BaseResponse r = this.executePost(url, null, file);
        UploadMediaResponse response = JSONUtil.toBean(r.getErrmsg(), UploadMediaResponse.class);
        return response;
    }

    public UploadMediaResponse uploadNews(List<Article> articles) {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("articles", articles);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        UploadMediaResponse response = JSONUtil.toBean(r.getErrmsg(), UploadMediaResponse.class);
        return response;
    }

    public UploadImgResponse uploadImg(File file) {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=#";
        BaseResponse r = this.executePost(url, null, file);
        UploadImgResponse response = JSONUtil.toBean(r.getErrmsg(), UploadImgResponse.class);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadMediaResponse downloadMedia(String mediaId) {
        DownloadMediaResponse response = new DownloadMediaResponse();
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=" + this.config.getAccessToken() + "&media_id=" + mediaId;
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        HttpGet get = new HttpGet(url);
        try {
            CloseableHttpResponse r = client.execute((HttpUriRequest)get);
            if (200 == r.getStatusLine().getStatusCode()) {
                InputStream inputStream = r.getEntity().getContent();
                Header[] headers = r.getHeaders("Content-disposition");
                if (null != headers && 0 != headers.length) {
                    Header length = r.getHeaders("Content-Length")[0];
                    response.setContent(inputStream, Integer.valueOf(length.getValue()));
                    response.setFileName(headers[0].getElements()[0].getParameterByName("filename").getValue());
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    StreamUtil.copy(inputStream, out);
                    String json = out.toString();
                    response = JSONUtil.toBean(json, DownloadMediaResponse.class);
                }
            }
        }
        catch (IOException e) {
            LOG.error("IO\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                LOG.error("\u5f02\u5e38", (Throwable)e);
            }
        }
        return response;
    }
}

