/**
 * Oshi (https://github.com/oshi/oshi)
 *
 * Copyright (c) 2010 - 2017 The Oshi Project Team
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Maintainers:
 * dblock[at]dblock[dot]org
 * widdis[at]gmail[dot]com
 * enrico.bianchi[at]gmail[dot]com
 *
 * Contributors:
 * https://github.com/oshi/oshi/graphs/contributors
 */
package oshi.json.software.os;

import oshi.json.json.OshiJsonObject;

/**
 * Detailed information about Operating System Version including code name and
 * build
 */
public interface OperatingSystemVersion extends OshiJsonObject {
    /**
     * @return the version
     */
    String getVersion();

    /**
     * @param version
     *            the version to set
     */
    void setVersion(String version);

    /**
     * @return the codeName
     */
    String getCodeName();

    /**
     * @param codeName
     *            the codeName to set
     */
    void setCodeName(String codeName);

    /**
     * @return the build number
     */
    String getBuildNumber();

    /**
     * @param buildNumber
     *            the build number to set
     */
    void setBuildNumber(String buildNumber);
}
