/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.result;

import com.cedarsoftware.util.io.JsonObject;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberTagResults;

public class CucumberScenarioResult {
    private String id;
    private CucumberTagResults[] tags;
    private String description;
    private String name;
    private String keyword;
    private Long line;
    private CucumberStepResult[] steps;
    private String type;
    private int passed = 0;
    private int failed = 0;
    private int undefined = 0;

    public CucumberScenarioResult(JsonObject<String, Object> json) {
        this.id = (String)json.get((Object)"id");
        this.description = (String)json.get((Object)"description");
        this.name = (String)json.get((Object)"name");
        this.keyword = (String)json.get((Object)"keyword");
        this.line = (Long)json.get((Object)"line");
        this.type = (String)json.get((Object)"type");
        if (json.containsKey((Object)"steps")) {
            Object[] objs = (Object[])((JsonObject)json.get((Object)"steps")).get((Object)"@items");
            this.steps = new CucumberStepResult[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                this.steps[i] = new CucumberStepResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            }
        }
        JsonObject tagEntry = (JsonObject)json.get((Object)"tags");
        Object[] objs = new Object[]{};
        if (tagEntry != null) {
            objs = (Object[])((JsonObject)json.get((Object)"tags")).get((Object)"@items");
        }
        this.tags = new CucumberTagResults[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            this.tags[i] = new CucumberTagResults((JsonObject<String, Object>)((JsonObject)objs[i]));
        }
    }

    public void valuate() {
        this.passed = 0;
        this.failed = 0;
        this.undefined = 0;
        if (this.steps == null) {
            return;
        }
        for (CucumberStepResult step : this.steps) {
            String status = step.getResult().getStatus();
            if (status.equalsIgnoreCase("passed")) {
                ++this.passed;
                continue;
            }
            if (status.equalsIgnoreCase("failed")) {
                ++this.failed;
                continue;
            }
            ++this.undefined;
        }
    }

    public final int getPassed() {
        return this.passed;
    }

    public final int getFailed() {
        return this.failed;
    }

    public final int getUndefined() {
        return this.undefined;
    }

    public String getStatus() {
        this.valuate();
        if (this.getFailed() > 0) {
            return "failed";
        }
        if (this.getUndefined() > 0) {
            return "undefined";
        }
        if (this.getPassed() > 0) {
            return "passed";
        }
        return "undefined";
    }

    public final String getId() {
        return this.id;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final String getKeyword() {
        return this.keyword;
    }

    public final Long getLine() {
        return this.line;
    }

    public final CucumberStepResult[] getSteps() {
        return this.steps;
    }

    public final String getType() {
        return this.type;
    }

    public final void setId(String idValue) {
        this.id = idValue;
    }

    public final void setDescription(String descriptionValue) {
        this.description = descriptionValue;
    }

    public final void setName(String nameValue) {
        this.name = nameValue;
    }

    public final void setKeyword(String keywordValue) {
        this.keyword = keywordValue;
    }

    public final void setLine(Long lineValue) {
        this.line = lineValue;
    }

    public final void setSteps(CucumberStepResult[] stepsValue) {
        this.steps = stepsValue;
    }

    public final void setType(String typeValue) {
        this.type = typeValue;
    }

    public final CucumberTagResults[] getTags() {
        return this.tags;
    }

    public final void setTags(CucumberTagResults[] tagsValue) {
        this.tags = tagsValue;
    }
}

