/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.CucumberResultsCommon;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class CucumberDetailedResults
extends CucumberResultsCommon {
    private String outputDirectory;
    private String outputName;
    private String screenShotLocation;
    private String screenShotWidth;

    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(String outputDirectoryValue) {
        this.outputDirectory = outputDirectoryValue;
    }

    public final String getOutputName() {
        return this.outputName;
    }

    public final void setOutputName(String outputNameValue) {
        this.outputName = outputNameValue;
    }

    public final String getScreenShotLocation() {
        return this.screenShotLocation;
    }

    public final void setScreenShotLocation(String screenShotLocationValue) {
        this.screenShotLocation = screenShotLocationValue;
    }

    public final String getScreenShotWidth() {
        return this.screenShotWidth;
    }

    public final void setScreenShotWidth(String screenShotWidthValue) {
        this.screenShotWidth = screenShotWidthValue;
    }

    private String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/results-report-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    private String generateOverview(CucumberFeatureResult[] results) {
        int featuresPassed = 0;
        int featuresFailed = 0;
        int featuresUndefined = 0;
        int scenariosPassed = 0;
        int scenariosFailed = 0;
        int scenariosUndefined = 0;
        int stepsPassed = 0;
        int stepsFailed = 0;
        int stepsUndefined = 0;
        float highestPercent = 100.0f;
        for (CucumberFeatureResult result : results) {
            if (result.getStatus().equals("passed")) {
                ++featuresPassed;
            } else if (result.getStatus().equals("failed")) {
                ++featuresFailed;
            } else {
                ++featuresUndefined;
            }
            scenariosPassed += result.getPassed();
            scenariosFailed += result.getFailed();
            scenariosUndefined += result.getUndefined();
            for (CucumberScenarioResult scenario : result.getElements()) {
                stepsPassed += scenario.getPassed();
                stepsFailed += scenario.getFailed();
                stepsUndefined += scenario.getUndefined();
            }
        }
        return String.format("<table><tr><th></th><th>Passed</th><th>Failed</th><th>Undefined</th><th>%%Passed</th></tr><tr><th>Features</th><td class=\"passed\">%d</td><td class=\"failed\">%d</td><td class=\"undefined\">%d</td><td>%.2f</td></tr><tr><th>Scenarios</th><td class=\"passed\">%d</td><td class=\"failed\">%d</td><td class=\"undefined\">%d</td><td>%.2f</td></tr><tr><th>Steps</th><td class=\"passed\">%d</td><td class=\"failed\">%d</td><td class=\"undefined\">%d</td><td>%.2f</td></tr></table>", featuresPassed, featuresFailed, featuresUndefined, Float.valueOf(100.0f * (float)featuresPassed / (float)(featuresPassed + featuresFailed + featuresUndefined)), scenariosPassed, scenariosFailed, scenariosUndefined, Float.valueOf(100.0f * (float)scenariosPassed / (float)(scenariosPassed + scenariosFailed + scenariosUndefined)), stepsPassed, stepsFailed, stepsUndefined, Float.valueOf(100.0f * (float)stepsPassed / (float)(stepsPassed + stepsFailed + stepsUndefined)));
    }

    private String generateNameFromId(String scId) {
        String result = scId.replaceAll("[; !@#$%^&*()+=]", "_");
        return result;
    }

    private String generateTableOfContents(CucumberFeatureResult[] results) {
        String reportContent = "";
        reportContent = reportContent + "<a id=\"top\"></a><h1>Table of Contents</h1><ol>";
        for (CucumberFeatureResult result : results) {
            reportContent = reportContent + String.format("<li> <span class=\"%s\"><a href=\"#feature-%s\">%s</a></span><ol>", result.getStatus(), result.getId(), result.getName());
            for (CucumberScenarioResult scenario : result.getElements()) {
                reportContent = reportContent + String.format("<li> <span class=\"%s\"><a href=\"#sc-%s\">%s</a></span></li>", scenario.getStatus(), scenario.getId(), scenario.getName());
            }
            reportContent = reportContent + "</ol></li>";
        }
        reportContent = reportContent + "</ol>";
        return reportContent;
    }

    private String generateStepRows(CucumberStepResult step) {
        String reportContent = "";
        if (step.getRows() != null) {
            reportContent = reportContent + String.format("<tr class=\"%s\"><td style=\"padding-left:20px\"><table>", step.getResult().getStatus());
            for (int i = 0; i < step.getRows().length; ++i) {
                reportContent = reportContent + "<tr>";
                for (int j = 0; j < step.getRows()[i].length; ++j) {
                    reportContent = reportContent + String.format("<td>%s</td>", step.getRows()[i][j]);
                }
                reportContent = reportContent + "</tr>";
            }
            reportContent = reportContent + "</table></td></tr>";
        }
        return reportContent;
    }

    private String generateScreenShot(CucumberScenarioResult scenario, CucumberStepResult step) {
        String reportContent = "";
        if (step.getResult().getStatus().trim().equalsIgnoreCase("failed")) {
            reportContent = reportContent + String.format("<tr class=\"%s\"><td><pre>%s%s</pre></td></tr>", step.getResult().getStatus(), System.lineSeparator(), step.getResult().getErrorMessage());
            String filePath = this.getScreenShotLocation() + this.generateNameFromId(scenario.getId()) + ".png";
            File shot = new File(this.outputDirectory + filePath);
            if (shot.exists()) {
                String widthString = "";
                if (StringUtils.isNotBlank((String)this.getScreenShotWidth())) {
                    widthString = String.format("width=\"%s\"", this.getScreenShotWidth());
                }
                reportContent = reportContent + String.format("<tr class=\"%s\"><td><img src=\"%s\" %s /></td></tr>", step.getResult().getStatus(), filePath, widthString);
            }
        }
        return reportContent;
    }

    private String generateStepsReport(CucumberFeatureResult[] results) throws IOException {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", "Detailed Results Report");
        content = content.replaceAll("__OVERVIEW__", this.generateOverview(results));
        String reportContent = "";
        reportContent = reportContent + this.generateTableOfContents(results);
        reportContent = reportContent + "<h1>Detailed Results Report</h1><table>";
        for (CucumberFeatureResult result : results) {
            reportContent = reportContent + String.format("<tr class=\"%s\"><td><b>Feature:</b> <a id=\"feature-%s\">%s</a></td><td><b>Passed:</b> %d</td><td><b>Failed:</b> %d</td><td><b>Undefined:</b> %d</td></tr><tr class=\"%s\"><td colspan=\"4\" style=\"padding-left:20px\"> <table width=\"100%%\">", result.getStatus(), result.getId(), result.getName(), result.getPassed(), result.getFailed(), result.getUndefined(), result.getStatus());
            for (CucumberScenarioResult scenario : result.getElements()) {
                reportContent = reportContent + String.format("<tr class=\"%s\"><td><b>Scenario:</b> <a id=\"sc-%s\">%s</a></td><td><b>Passed:</b> %d</td><td><b>Failed:</b> %d</td><td><b>Undefined:</b> %d</td></tr><tr class=\"%s\"><td colspan=\"4\" style=\"padding-left:20px\"> <table width=\"100%%\">", scenario.getStatus(), scenario.getId(), scenario.getName(), scenario.getPassed(), scenario.getFailed(), scenario.getUndefined(), scenario.getStatus());
                for (CucumberStepResult step : scenario.getSteps()) {
                    reportContent = reportContent + String.format("<tr class=\"%s\"><td><b>%s</b> %s</td></tr>", step.getResult().getStatus(), step.getKeyword(), step.getName());
                    reportContent = reportContent + this.generateStepRows(step);
                    reportContent = reportContent + this.generateScreenShot(scenario, step);
                }
                reportContent = reportContent + "</table></td></tr><tr><td colspan=\"5\"><sup><a href=\"#top\">Back to Table of Contents</a></sup></td></tr>";
            }
            reportContent = reportContent + "</table></td></tr><tr><td colspan=\"5\"></td></tr>";
        }
        reportContent = reportContent + "</table>";
        content = content.replaceAll("__REPORT__", reportContent);
        return content;
    }

    public void executeDetailedResultsReport(boolean toPdf) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent();
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-test-results.html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateStepsReport(features));
        if (toPdf) {
            String url = outFile.toURI().toURL().toString();
            String outputFile = this.getOutputDirectory() + File.separator + this.getOutputName() + "-test-results.pdf";
            FileOutputStream os = new FileOutputStream(outputFile);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(url);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
    }
}

