/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.spring.boot.redis.mock;

import com.github.microwww.redis.RedisServer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="mocker.redis", value={"enable"}, havingValue="true", matchIfMissing=true)
public class RedisServerListener {
    private static final Logger logger = LoggerFactory.getLogger(RedisServerListener.class);
    private static RedisServer server;
    private static AtomicInteger count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Bean(destroyMethod="close")
    public RedisServer mockRedisServer(RedisProperties redisProperties) throws IOException {
        if (server == null) {
            Class<RedisServerListener> clazz = RedisServerListener.class;
            // MONITORENTER : com.github.microwww.spring.boot.redis.mock.RedisServerListener.class
            if (server == null) {
                RedisServer server = new RedisServer(){

                    public void close() throws IOException {
                        if (count.decrementAndGet() <= 0) {
                            logger.info("Mocker Redis will STOP !");
                            super.close();
                        }
                    }
                };
                server.listener(redisProperties.getHost(), redisProperties.getPort());
                RedisServerListener.server = server;
            }
            // MONITOREXIT : clazz
        }
        count.incrementAndGet();
        logger.info("Mocker Redis start :: [{}:{}], set 'server.redis.host' to match it", (Object)redisProperties.getHost(), (Object)redisProperties.getPort());
        return server;
    }

    static {
        count = new AtomicInteger(0);
    }
}

