/*
 * Decompiled with CFR 0.152.
 */
package com.github.mchernyakov.variousttlmap.util;

import com.github.mchernyakov.variousttlmap.util.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class ThreadUtil {
    private ThreadUtil() {
    }

    public static ThreadFactory threadFactory(String threadName, boolean isDaemon) {
        return new ThreadFactoryBuilder().setNameFormat(threadName + "-%d").setDaemon(isDaemon).build();
    }

    public static ThreadFactory threadFactory(String threadName) {
        return ThreadUtil.threadFactory(threadName, true);
    }

    public static void shutdownExecutorService(ExecutorService executorService) {
        ThreadUtil.shutdownExecutorService(executorService, 5);
    }

    public static void shutdownExecutorService(ExecutorService executorService, int timeoutS) {
        if (executorService != null && !executorService.isShutdown()) {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(timeoutS, TimeUnit.SECONDS)) {
                    executorService.shutdownNow();
                    executorService.awaitTermination(timeoutS, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

