/*
 * Decompiled with CFR 0.152.
 */
package org.encryptor4j.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.encryptor4j.Encryptor;
import org.encryptor4j.factory.EncryptorFactory;
import org.encryptor4j.factory.KeyFactory;

public class TextEncryptor {
    private Encryptor encryptor;

    public TextEncryptor() {
        this(KeyFactory.AES.randomKey());
    }

    public TextEncryptor(String password) {
        this(KeyFactory.AES.keyFromPassword(password.toCharArray()));
    }

    public TextEncryptor(Key key) {
        this(EncryptorFactory.AES.messageEncryptor(key));
    }

    public TextEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public String encrypt(String message) throws GeneralSecurityException {
        byte[] bytes = this.encryptor.encrypt(message.getBytes());
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String decrypt(String message) throws GeneralSecurityException {
        byte[] bytes = Base64.getDecoder().decode(message);
        return new String(this.encryptor.decrypt(bytes));
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public static void main(String[] args) {
        block11: {
            Options options = new Options();
            options.addOption(Option.builder((String)"t").longOpt("text").hasArg().argName("text").desc("message text").required().build());
            options.addOption(Option.builder((String)"d").longOpt("decrypt").desc("decrypt").build());
            options.addOption(Option.builder((String)"p").longOpt("password").hasArg().argName("password").desc("password").build());
            options.addOption(Option.builder((String)"k").longOpt("key").hasArg().argName("key").desc("Base64 encoded key").build());
            if (args != null && args.length > 0) {
                TextEncryptor te;
                CommandLine cmd;
                DefaultParser parser = new DefaultParser();
                try {
                    cmd = parser.parse(options, args);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Could not parse args", e);
                }
                String text = cmd.getOptionValue("t");
                if (cmd.hasOption("p")) {
                    te = new TextEncryptor(cmd.getOptionValue("p"));
                } else if (cmd.hasOption("k")) {
                    String encodedKey = cmd.getOptionValue("k");
                    byte[] keyBytes = Base64.getDecoder().decode(encodedKey);
                    SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
                    te = new TextEncryptor(key);
                } else {
                    te = new TextEncryptor();
                    byte[] keyBytes = te.getEncryptor().getKey().getEncoded();
                    String encodedKey = Base64.getEncoder().encodeToString(keyBytes);
                    System.out.println("Base64 encoded key: " + encodedKey);
                }
                try {
                    if (cmd.hasOption("d")) {
                        String decrypted = te.decrypt(text);
                        System.out.println("Decrypted message:");
                        System.out.println(decrypted);
                        break block11;
                    }
                    String encrypted = te.encrypt(text);
                    System.out.println("Encrypted message:");
                    System.out.println(encrypted);
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            } else {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(TextEncryptor.class.getSimpleName(), options);
            }
        }
        System.exit(0);
    }
}

