/*
 * Decompiled with CFR 0.152.
 */
package org.encryptor4j;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import javax.crypto.KeyAgreement;

public abstract class KeyAgreementPeer {
    private KeyAgreement keyAgreement;
    private KeyPair keyPair;

    public KeyAgreementPeer(KeyAgreement keyAgreement) throws GeneralSecurityException {
        this.keyAgreement = keyAgreement;
    }

    protected abstract KeyPair createKeyPair() throws GeneralSecurityException;

    protected void initialize() throws GeneralSecurityException {
        this.keyPair = this.createKeyPair();
        this.keyAgreement.init(this.keyPair.getPrivate());
    }

    public byte[] computeSharedSecret(Key key) throws InvalidKeyException {
        this.keyAgreement.doPhase(key, true);
        return this.keyAgreement.generateSecret();
    }

    public Key getPublicKey() {
        return this.keyPair.getPublic();
    }

    public KeyAgreement getKeyAgreement() {
        return this.keyAgreement;
    }
}

