/*
 * Decompiled with CFR 0.152.
 */
package org.encryptor4j;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.encryptor4j.KeyAgreementPeer;

public class ECDHPeer
extends KeyAgreementPeer {
    private static final String ALGORITHM = "ECDH";
    private AlgorithmParameterSpec spec;

    public ECDHPeer(String curve) throws GeneralSecurityException {
        this((AlgorithmParameterSpec)ECNamedCurveTable.getParameterSpec((String)curve), "BC");
    }

    public ECDHPeer(BigInteger p, BigInteger a, BigInteger b, BigInteger xg, BigInteger yg, BigInteger n, int h) throws GeneralSecurityException {
        this(new ECParameterSpec(new EllipticCurve(new ECFieldFp(p), a, b), new ECPoint(xg, yg), n, h), null);
    }

    public ECDHPeer(AlgorithmParameterSpec spec) throws GeneralSecurityException {
        this(spec, null);
    }

    public ECDHPeer(AlgorithmParameterSpec spec, String provider) throws GeneralSecurityException {
        super(provider != null ? KeyAgreement.getInstance(ALGORITHM, provider) : KeyAgreement.getInstance(ALGORITHM));
        this.spec = spec;
        this.initialize();
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.spec;
    }

    @Override
    protected KeyPair createKeyPair() throws GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM, this.getKeyAgreement().getProvider());
        keyGen.initialize(this.spec, new SecureRandom());
        return keyGen.generateKeyPair();
    }
}

