/*
 * Decompiled with CFR 0.152.
 */
package org.encryptor4j;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import org.encryptor4j.KeyAgreementPeer;

public class DHPeer
extends KeyAgreementPeer {
    private static final String ALGORITHM = "DH";
    private BigInteger p;
    private BigInteger g;

    public DHPeer(BigInteger p, BigInteger g) throws GeneralSecurityException {
        this(p, g, null);
    }

    public DHPeer(BigInteger p, BigInteger g, String provider) throws GeneralSecurityException {
        super(provider != null ? KeyAgreement.getInstance(ALGORITHM, provider) : KeyAgreement.getInstance(ALGORITHM));
        this.p = p;
        this.g = g;
        this.initialize();
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    @Override
    protected KeyPair createKeyPair() throws GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM, this.getKeyAgreement().getProvider());
        keyGen.initialize(new DHParameterSpec(this.p, this.g), new SecureRandom());
        return keyGen.generateKeyPair();
    }
}

