/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import com.notification.Notification;
import com.notification.NotificationFactory;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

public class Screen {
    private int m_width;
    private int m_height;
    private int m_leftX;
    private int m_centerX;
    private int m_rightX;
    private int m_topY;
    private int m_centerY;
    private int m_bottomY;
    private int m_padding;

    private Screen(boolean spanMultipleMonitors, int padding) {
        this.m_padding = padding;
        this.setupDimensions(spanMultipleMonitors);
        this.calculatePositions();
    }

    public static Screen standard() {
        return new Screen(true, 80);
    }

    public static Screen withSpan(boolean spanMultipleMonitors) {
        return new Screen(spanMultipleMonitors, 80);
    }

    public static Screen withPadding(int padding) {
        return new Screen(true, padding);
    }

    public static Screen withSpanAndPadding(boolean spanMultipleMonitors, int padding) {
        return new Screen(spanMultipleMonitors, padding);
    }

    private void setupDimensions(boolean spanMultipleMonitors) {
        if (spanMultipleMonitors) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.m_width = screenSize.width;
            this.m_height = screenSize.height;
        } else {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            this.m_width = gd.getDisplayMode().getWidth();
            this.m_height = gd.getDisplayMode().getHeight();
        }
    }

    private void calculatePositions() {
        this.m_leftX = this.m_padding;
        this.m_centerX = (int)((double)this.m_width / 2.0);
        this.m_rightX = this.m_width - this.m_padding;
        this.m_topY = this.m_padding;
        this.m_centerY = (int)((double)this.m_height / 2.0);
        this.m_bottomY = this.m_height - this.m_padding;
    }

    public int getX(NotificationFactory.Location loc, Notification note) {
        switch (loc) {
            case SOUTHWEST: {
                return this.m_leftX;
            }
            case WEST: {
                return this.m_leftX;
            }
            case NORTHWEST: {
                return this.m_leftX;
            }
            case NORTH: {
                return this.m_centerX - note.getWidth() / 2;
            }
            case SOUTH: {
                return this.m_centerX - note.getWidth() / 2;
            }
            case SOUTHEAST: {
                return this.m_rightX - note.getWidth();
            }
            case EAST: {
                return this.m_rightX - note.getWidth();
            }
            case NORTHEAST: {
                return this.m_rightX - note.getWidth();
            }
        }
        return -1;
    }

    public int getY(NotificationFactory.Location loc, Notification note) {
        switch (loc) {
            case SOUTHWEST: {
                return this.m_bottomY - note.getHeight();
            }
            case WEST: {
                return this.m_centerY - note.getHeight() / 2;
            }
            case NORTHWEST: {
                return this.m_topY;
            }
            case NORTH: {
                return this.m_topY;
            }
            case SOUTH: {
                return this.m_bottomY - note.getHeight();
            }
            case SOUTHEAST: {
                return this.m_bottomY - note.getHeight();
            }
            case EAST: {
                return this.m_centerY - note.getHeight() / 2;
            }
            case NORTHEAST: {
                return this.m_topY;
            }
        }
        return -1;
    }

    public int getPadding() {
        return this.m_padding;
    }
}

