/*
 * Decompiled with CFR 0.152.
 */
package com.demo;

import com.notification.NotificationFactory;
import com.notification.manager.SimpleManager;
import com.notification.types.AcceptNotification;
import com.notification.types.IconNotification;
import com.notification.types.ProgressBarNotification;
import com.notification.types.TextNotification;
import com.theme.ThemePackagePresets;
import com.utils.IconUtils;
import com.utils.Time;

public class SimpleManagerDemo {
    public static void main(String[] args) throws InterruptedException {
        NotificationFactory factory = new NotificationFactory(ThemePackagePresets.cleanDark());
        SimpleManager plain = new SimpleManager(NotificationFactory.Location.NORTHWEST);
        SimpleManager fade = new SimpleManager(NotificationFactory.Location.SOUTHWEST);
        fade.setFadeEnabled(true);
        fade.setFadeTime(Time.seconds(2.0));
        TextNotification notification = factory.buildTextNotification("This is the dark theme", "You can have multiple lines\nOf subtitle text as well\nLine 3");
        notification.setCloseOnClick(true);
        plain.addNotification(notification, Time.infinite());
        Thread.sleep(2000L);
        IconNotification icon = factory.buildIconNotification("This is a really really really long title", "See the cutoff?", IconUtils.createIcon("/com/demo/exclamation.png", 50, 50));
        fade.addNotification(icon, Time.seconds(2.0));
        Thread.sleep(6000L);
        AcceptNotification accept = factory.buildAcceptNotification("Do you accept?", "This is a fading notification.");
        fade.addNotification(accept, Time.infinite());
        boolean didAccept = accept.blockUntilReply();
        ProgressBarNotification reply = null;
        reply = didAccept ? factory.buildProgressBarNotification("You accepted") : factory.buildProgressBarNotification("You did not accept");
        reply.setCloseOnClick(true);
        fade.addNotification(reply, Time.infinite());
        for (int i = 0; i < 100; ++i) {
            reply.setProgress(i);
            Thread.sleep(100L);
        }
        fade.removeNotification(reply);
    }
}

