/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.addon.krasa.Utils;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.AttributeUseImpl;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.impl.ParticleImpl;
import com.sun.xml.xsom.impl.RestrictionSimpleTypeImpl;
import com.sun.xml.xsom.impl.parser.DelayedRef;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbValidationsPlugins
extends Plugin {
    public static final String PLUGIN_OPTION_NAME = "XJsr303Annotations";
    public static final String TARGET_NAMESPACE_PARAMETER_NAME = "XJsr303Annotations:targetNamespace";
    public static final String JSR_349 = "XJsr303Annotations:JSR_349";
    public static final String GENERATE_NOT_NULL_ANNOTATIONS = "XJsr303Annotations:generateNotNullAnnotations";
    public static final String VERBOSE = "XJsr303Annotations:verbose";
    protected String namespace = "http://jaxb.dev.java.net/plugin/code-injector";
    public String targetNamespace = null;
    public boolean jsr349 = false;
    public boolean verbose = true;
    public boolean notNullAnnotations = true;

    public String getOptionName() {
        return PLUGIN_OPTION_NAME;
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int index_verbose;
        int index_generateNotNullAnnotations;
        int index;
        String arg1 = args[i];
        int consumed = 0;
        int indexOfNamespace = arg1.indexOf(TARGET_NAMESPACE_PARAMETER_NAME);
        if (indexOfNamespace > 0) {
            this.targetNamespace = arg1.substring(indexOfNamespace + TARGET_NAMESPACE_PARAMETER_NAME.length() + "=".length());
            ++consumed;
        }
        if ((index = arg1.indexOf(JSR_349)) > 0) {
            this.jsr349 = Boolean.parseBoolean(arg1.substring(index + JSR_349.length() + "=".length()));
            ++consumed;
        }
        if ((index_generateNotNullAnnotations = arg1.indexOf(GENERATE_NOT_NULL_ANNOTATIONS)) > 0) {
            this.notNullAnnotations = Boolean.parseBoolean(arg1.substring(index_generateNotNullAnnotations + GENERATE_NOT_NULL_ANNOTATIONS.length() + "=".length()));
            ++consumed;
        }
        if ((index_verbose = arg1.indexOf(VERBOSE)) > 0) {
            this.verbose = Boolean.parseBoolean(arg1.substring(index_verbose + VERBOSE.length() + "=".length()));
            ++consumed;
        }
        return consumed;
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(this.namespace);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals(this.namespace) && localName.equals("code");
    }

    public void onActivated(Options opts) throws BadCommandLineException {
        super.onActivated(opts);
    }

    public String getUsage() {
        return "  -XJsr303Annotations      :  inject Bean validation annotations (JSR 303); -XJsr303Annotations:targetNamespace=http://www.foo.com/bar  :      additional settings for @Valid annotation";
    }

    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        try {
            for (ClassOutline co : model.getClasses()) {
                List properties = co.target.getProperties();
                for (CPropertyInfo property : properties) {
                    if (property instanceof CElementPropertyInfo) {
                        this.processElement((CElementPropertyInfo)property, co, model);
                        continue;
                    }
                    if (property instanceof CAttributePropertyInfo) {
                        this.processAttribute((CAttributePropertyInfo)property, co, model);
                        continue;
                    }
                    if (!(property instanceof CValuePropertyInfo)) continue;
                    this.processAttribute((CValuePropertyInfo)property, co, model);
                }
            }
            return true;
        }
        catch (Exception e) {
            this.log(e);
            return false;
        }
    }

    public void processElement(CElementPropertyInfo property, ClassOutline classOutline, Outline model) {
        XSTerm term;
        XSComponent schemaComponent = property.getSchemaComponent();
        ParticleImpl particle = (ParticleImpl)schemaComponent;
        int maxOccurs = Utils.toInt(Utils.getField("maxOccurs", particle));
        int minOccurs = Utils.toInt(Utils.getField("minOccurs", particle));
        JFieldVar field = (JFieldVar)classOutline.implClass.fields().get(this.propertyName(property));
        boolean required = property.isRequired();
        if ((minOccurs < 0 || minOccurs >= 1 && required) && !this.hasAnnotation(field, NotNull.class) && this.notNullAnnotations) {
            this.log("@NotNull: " + this.propertyName(property) + " added to class " + classOutline.implClass.name());
            field.annotate(NotNull.class);
        }
        if (maxOccurs > 1 && !this.hasAnnotation(field, Size.class)) {
            this.log("@Size (" + minOccurs + "," + maxOccurs + ") " + this.propertyName(property) + " added to class " + classOutline.implClass.name());
            field.annotate(Size.class).param("min", minOccurs).param("max", maxOccurs);
        }
        if (maxOccurs == -1 && minOccurs > 0 && !this.hasAnnotation(field, Size.class)) {
            this.log("@Size (" + minOccurs + ") " + this.propertyName(property) + " added to class " + classOutline.implClass.name());
            field.annotate(Size.class).param("min", minOccurs);
        }
        if ((term = particle.getTerm()) instanceof ElementDecl) {
            this.processElement(property, classOutline, field, (ElementDecl)term);
        } else if (term instanceof DelayedRef.Element) {
            XSElementDecl xsElementDecl = ((DelayedRef.Element)term).get();
            this.processElement(property, classOutline, field, (ElementDecl)xsElementDecl);
        }
    }

    private void processElement(CElementPropertyInfo property, ClassOutline clase, JFieldVar var, ElementDecl element) {
        String propertyName = this.propertyName(property);
        String className = clase.implClass.name();
        XSType elementType = element.getType();
        this.validAnnotation(elementType, var, propertyName, className);
        if (elementType instanceof XSSimpleType) {
            this.processType((XSSimpleType)elementType, var, propertyName, className);
        } else if (elementType.getBaseType() instanceof XSSimpleType) {
            this.processType((XSSimpleType)elementType.getBaseType(), var, propertyName, className);
        }
    }

    private void validAnnotation(XSType elementType, JFieldVar var, String propertyName, String className) {
        if ((this.targetNamespace == null || elementType.getTargetNamespace().startsWith(this.targetNamespace)) && elementType.isComplexType() && !this.hasAnnotation(var, Valid.class)) {
            this.log("@Valid: " + propertyName + " added to class " + className);
            var.annotate(Valid.class);
        }
    }

    public void processType(XSSimpleType simpleType, JFieldVar field, String propertyName, String className) {
        List patternList;
        XSFacet minExclusive;
        XSFacet maxExclusive;
        XSFacet minInclusive;
        XSFacet maxInclusive;
        if (!this.hasAnnotation(field, Size.class) && this.isSizeAnnotationApplicable(field)) {
            Integer minLength;
            Integer maxLength = simpleType.getFacet("maxLength") == null ? null : Utils.parseInt(simpleType.getFacet((String)"maxLength").getValue().value);
            Integer n = minLength = simpleType.getFacet("minLength") == null ? null : Utils.parseInt(simpleType.getFacet((String)"minLength").getValue().value);
            if (maxLength != null && minLength != null) {
                this.log("@Size(" + minLength + "," + maxLength + "): " + propertyName + " added to class " + className);
                field.annotate(Size.class).param("min", minLength.intValue()).param("max", maxLength.intValue());
            } else if (minLength != null) {
                this.log("@Size(" + minLength + ", null): " + propertyName + " added to class " + className);
                field.annotate(Size.class).param("min", minLength.intValue());
            } else if (maxLength != null) {
                this.log("@Size(null, " + maxLength + "): " + propertyName + " added to class " + className);
                field.annotate(Size.class).param("max", maxLength.intValue());
            }
        }
        if ((maxInclusive = simpleType.getFacet("maxInclusive")) != null && Utils.isNumber(field) && this.isValidValue(maxInclusive) && !this.hasAnnotation(field, DecimalMax.class)) {
            this.log("@DecimalMax(" + maxInclusive.getValue().value + "): " + propertyName + " added to class " + className);
            field.annotate(DecimalMax.class).param("value", maxInclusive.getValue().value);
        }
        if ((minInclusive = simpleType.getFacet("minInclusive")) != null && Utils.isNumber(field) && this.isValidValue(minInclusive) && !this.hasAnnotation(field, DecimalMin.class)) {
            this.log("@DecimalMin(" + minInclusive.getValue().value + "): " + propertyName + " added to class " + className);
            field.annotate(DecimalMin.class).param("value", minInclusive.getValue().value);
        }
        if ((maxExclusive = simpleType.getFacet("maxExclusive")) != null && Utils.isNumber(field) && this.isValidValue(maxExclusive) && !this.hasAnnotation(field, DecimalMax.class)) {
            this.log("@DecimalMax(" + maxExclusive.getValue().value + "): " + propertyName + " added to class " + className);
            JAnnotationUse annotate = field.annotate(DecimalMax.class);
            annotate.param("value", maxExclusive.getValue().value);
            if (this.jsr349) {
                annotate.param("inclusive", false);
            }
        }
        if ((minExclusive = simpleType.getFacet("minExclusive")) != null && Utils.isNumber(field) && this.isValidValue(minExclusive) && !this.hasAnnotation(field, DecimalMin.class)) {
            this.log("@DecimalMin(" + minExclusive.getValue().value + "): " + propertyName + " added to class " + className);
            JAnnotationUse annotate = field.annotate(DecimalMin.class);
            annotate.param("value", minExclusive.getValue().value);
            if (this.jsr349) {
                annotate.param("inclusive", false);
            }
        }
        if (simpleType.getFacet("totalDigits") != null && Utils.isNumber(field)) {
            int fractionDigits;
            Integer totalDigits = simpleType.getFacet("totalDigits") == null ? null : Utils.parseInt(simpleType.getFacet((String)"totalDigits").getValue().value);
            int n = fractionDigits = simpleType.getFacet("fractionDigits") == null ? 0 : Utils.parseInt(simpleType.getFacet((String)"fractionDigits").getValue().value);
            if (!this.hasAnnotation(field, Digits.class)) {
                this.log("@Digits(" + totalDigits + "," + fractionDigits + "): " + propertyName + " added to class " + className);
                JAnnotationUse annox = field.annotate(Digits.class).param("integer", totalDigits - fractionDigits);
                annox.param("fraction", fractionDigits);
            }
        }
        if ((patternList = simpleType.getFacets("pattern")).size() > 1) {
            this.log("@Pattern.List: " + propertyName + " added to class " + className);
            JAnnotationUse patternListAnnotation = field.annotate(Pattern.List.class);
            JAnnotationArrayMember listValue = patternListAnnotation.paramArray("value");
            for (XSFacet xsFacet : patternList) {
                String value;
                if (!"String".equals(field.type().name()) || "\\c+".equals(value = xsFacet.getValue().value)) continue;
                listValue.annotate(Pattern.class).param("regexp", this.replaceXmlProprietals(value));
            }
        } else if (simpleType.getFacet("pattern") != null) {
            String pattern = simpleType.getFacet((String)"pattern").getValue().value;
            if ("String".equals(field.type().name()) && !"\\c+".equals(pattern)) {
                this.log("@Pattern(" + pattern + "): " + propertyName + " added to class " + className);
                if (!this.hasAnnotation(field, Pattern.class)) {
                    field.annotate(Pattern.class).param("regexp", this.replaceXmlProprietals(pattern));
                }
            }
        }
    }

    private String replaceXmlProprietals(String pattern) {
        return pattern.replace("\\i", "[_:A-Za-z]").replace("\\c", "[-._:A-Za-z0-9]");
    }

    private boolean isSizeAnnotationApplicable(JFieldVar field) {
        return field.type().name().equals("String") || field.type().isArray();
    }

    private void processAttribute(CValuePropertyInfo property, ClassOutline clase, Outline model) {
        FieldOutline field = model.getField((CPropertyInfo)property);
        String propertyName = property.getName(false);
        String className = clase.implClass.name();
        this.log("Attribute " + propertyName + " added to class " + className);
        XSComponent definition = property.getSchemaComponent();
        RestrictionSimpleTypeImpl particle = (RestrictionSimpleTypeImpl)definition;
        XSSimpleType type = particle.asSimpleType();
        JFieldVar var = (JFieldVar)clase.implClass.fields().get(propertyName);
        this.validAnnotation((XSType)type, var, propertyName, className);
        this.processType(type, var, propertyName, className);
    }

    public void processAttribute(CAttributePropertyInfo property, ClassOutline clase, Outline model) {
        FieldOutline field = model.getField((CPropertyInfo)property);
        String propertyName = property.getName(false);
        String className = clase.implClass.name();
        this.log("Attribute " + propertyName + " added to class " + className);
        XSComponent definition = property.getSchemaComponent();
        AttributeUseImpl particle = (AttributeUseImpl)definition;
        XSSimpleType type = particle.getDecl().getType();
        JFieldVar var = (JFieldVar)clase.implClass.fields().get(propertyName);
        if (particle.isRequired() && !this.hasAnnotation(var, NotNull.class) && this.notNullAnnotations) {
            this.log("@NotNull: " + propertyName + " added to class " + className);
            var.annotate(NotNull.class);
        }
        this.validAnnotation((XSType)type, var, propertyName, className);
        this.processType(type, var, propertyName, className);
    }

    protected boolean isValidValue(XSFacet facet) {
        String value = facet.getValue().value;
        return value != null && !Utils.isMax(value) && !Utils.isMin(value);
    }

    public boolean hasAnnotation(JFieldVar var, Class annotationClass) {
        List list = (List)Utils.getField("annotations", var);
        if (list != null) {
            for (JAnnotationUse annotationUse : list) {
                if (!((Class)Utils.getField("clazz._class", annotationUse)).getCanonicalName().equals(annotationClass.getCanonicalName())) continue;
                return true;
            }
        }
        return false;
    }

    private String propertyName(CElementPropertyInfo property) {
        return property.getName(false);
    }

    private void log(Exception e) {
        e.printStackTrace();
    }

    private void log(String log) {
        if (this.verbose) {
            System.out.println(log);
        }
    }
}

