/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.serializer;

import com.github.kagkarlsson.scheduler.exceptions.SerializationException;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JavaSerializer
implements Serializer {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(Object data) {
        if (data == null) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(data);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize object", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(Class<T> clazz, byte[] serializedData) {
        if (serializedData == null) {
            return null;
        }
        try (ByteArrayInputStream bis = new ByteArrayInputStream(serializedData);){
            T t;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                t = clazz.cast(in.readObject());
            }
            return t;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize object", e);
        }
    }
}

