/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import java.util.Optional;

public class ScheduledExecutionsFilter {
    private Boolean pickedValue;
    private boolean includeUnresolved = false;

    private ScheduledExecutionsFilter() {
    }

    public static ScheduledExecutionsFilter all() {
        return new ScheduledExecutionsFilter().withIncludeUnresolved(true);
    }

    public static ScheduledExecutionsFilter onlyResolved() {
        return new ScheduledExecutionsFilter().withIncludeUnresolved(false);
    }

    public ScheduledExecutionsFilter withPicked(boolean pickedValue) {
        this.pickedValue = pickedValue;
        return this;
    }

    public ScheduledExecutionsFilter withIncludeUnresolved(boolean includeUnresolved) {
        this.includeUnresolved = includeUnresolved;
        return this;
    }

    public Optional<Boolean> getPickedValue() {
        return Optional.ofNullable(this.pickedValue);
    }

    public boolean getIncludeUnresolved() {
        return this.includeUnresolved;
    }
}

