/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunAndLogErrors
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RunAndLogErrors.class);
    private final Runnable toRun;
    private final StatsRegistry statsRegistry;

    public RunAndLogErrors(Runnable toRun, StatsRegistry statsRegistry) {
        this.toRun = toRun;
        this.statsRegistry = statsRegistry;
    }

    @Override
    public void run() {
        try {
            this.toRun.run();
        }
        catch (Throwable e) {
            LOG.error("Unhandled exception. Will keep running.", e);
            this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.UNEXPECTED_ERROR);
        }
    }
}

