/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

public class PollingStrategyConfig {
    public static final PollingStrategyConfig DEFAULT_FETCH = new PollingStrategyConfig(Type.FETCH, 0.5, 3.0);
    public static final PollingStrategyConfig DEFAULT_SELECT_FOR_UPDATE = new PollingStrategyConfig(Type.LOCK_AND_FETCH, 0.5, 1.0);
    public final Type type;
    public final double lowerLimitFractionOfThreads;
    public final double upperLimitFractionOfThreads;

    public int getUpperLimit(int threadpoolSize) {
        return (int)(this.upperLimitFractionOfThreads * (double)threadpoolSize);
    }

    public int getLowerLimit(int threadpoolSize) {
        return (int)(this.lowerLimitFractionOfThreads * (double)threadpoolSize);
    }

    public PollingStrategyConfig(Type type, double lowerLimitFractionOfThreads, double upperLimitFractionOfThreads) {
        this.type = type;
        this.lowerLimitFractionOfThreads = lowerLimitFractionOfThreads;
        this.upperLimitFractionOfThreads = upperLimitFractionOfThreads;
        if (lowerLimitFractionOfThreads >= upperLimitFractionOfThreads) {
            throw new IllegalArgumentException("lowerLimitFractionOfThreads should be lower than upperLimitFractionOfThreads");
        }
        if (upperLimitFractionOfThreads < 1.0) {
            throw new IllegalArgumentException("upperLimit should be equals to number of threads or higher, i.e. fraction higher than 1");
        }
    }

    public String describe() {
        return "type=" + this.type.name() + ", lowerLimit=" + this.lowerLimitFractionOfThreads + ", upperLimit=" + this.upperLimitFractionOfThreads;
    }

    public static enum Type {
        LOCK_AND_FETCH,
        FETCH;

    }
}

