/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.paypal;

import cn.hutool.core.util.StrUtil;
import com.ijpay.paypal.PayPalApiConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PayPalApiConfigKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, PayPalApiConfig> CFG_MAP = new ConcurrentHashMap<String, PayPalApiConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_key_";

    public static PayPalApiConfig putApiConfig(PayPalApiConfig config) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, config);
        }
        return CFG_MAP.put(config.getClientId(), config);
    }

    public static PayPalApiConfig setThreadLocalApiConfig(PayPalApiConfig config) {
        if (StrUtil.isNotEmpty((CharSequence)config.getClientId())) {
            PayPalApiConfigKit.setThreadLocalClientId(config.getClientId());
        }
        return PayPalApiConfigKit.putApiConfig(config);
    }

    public static PayPalApiConfig removeApiConfig(PayPalApiConfig config) {
        return PayPalApiConfigKit.removeApiConfig(config.getClientId());
    }

    public static PayPalApiConfig removeApiConfig(String clientId) {
        return CFG_MAP.remove(clientId);
    }

    public static boolean removeAllApiConfig() {
        Set<String> keySet = CFG_MAP.keySet();
        for (String str : keySet) {
            System.out.println(str);
            CFG_MAP.remove(str);
        }
        PayPalApiConfigKit.removeThreadLocalClientId();
        return true;
    }

    public static void setThreadLocalClientId(String clientId) {
        if (StrUtil.isEmpty((CharSequence)clientId)) {
            clientId = CFG_MAP.get(DEFAULT_CFG_KEY).getClientId();
        }
        TL.set(clientId);
    }

    public static void removeThreadLocalClientId() {
        TL.remove();
    }

    public static String getClientId() {
        String clientId = TL.get();
        if (StrUtil.isEmpty((CharSequence)clientId)) {
            clientId = CFG_MAP.get(DEFAULT_CFG_KEY).getClientId();
        }
        return clientId;
    }

    public static PayPalApiConfig getApiConfig() {
        return PayPalApiConfigKit.getApiConfig(PayPalApiConfigKit.getClientId());
    }

    public static PayPalApiConfig getApiConfig(String clientId) {
        PayPalApiConfig cfg = CFG_MAP.get(clientId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 PayPalApiConfigKit.putApiConfig(payPalApiConfig) \u5c06 clientId \u5bf9\u5e94\u7684 payPalApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 PayPalApiConfigKit.getApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }
}

