/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.log4j2;

import com.github.houbb.log.integration.adaptors.log4j2.Log4j2Impl;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.LogUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class Log4j2AbstractLoggerImpl
implements Log {
    private static final Marker MARKER = MarkerManager.getMarker((String)"LOG-INTEGRATION");
    private static final String FQCN = Log4j2Impl.class.getName();
    private ExtendedLoggerWrapper log;

    public Log4j2AbstractLoggerImpl(AbstractLogger abstractLogger) {
        this.log = new ExtendedLoggerWrapper((ExtendedLogger)abstractLogger, abstractLogger.getName(), abstractLogger.getMessageFactory());
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public void fatal(String s, Throwable e) {
        Throwable throwable = e;
        this.log.logIfEnabled(FQCN, Level.FATAL, MARKER, s, throwable);
    }

    @Override
    public void fatal(String s) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.FATAL, MARKER, s, throwable);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.logIfEnabled(FQCN, Level.ERROR, MARKER, s, e);
    }

    @Override
    public void error(String s) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.ERROR, MARKER, s, throwable);
    }

    @Override
    public void debug(String s) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.DEBUG, MARKER, s, throwable);
    }

    @Override
    public void trace(String s) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.TRACE, MARKER, s, throwable);
    }

    @Override
    public void warn(String s) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.WARN, MARKER, s, throwable);
    }

    @Override
    public void info(String s) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.INFO, MARKER, s, throwable);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        Throwable throwable = e;
        this.log.logIfEnabled(FQCN, Level.FATAL, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }

    @Override
    public void fatal(String s, Object ... params) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.FATAL, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        Throwable throwable = e;
        this.log.logIfEnabled(FQCN, Level.ERROR, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }

    @Override
    public void error(String s, Object ... params) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.ERROR, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }

    @Override
    public void debug(String s, Object ... params) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.DEBUG, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }

    @Override
    public void trace(String s, Object ... params) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.TRACE, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }

    @Override
    public void warn(String s, Object ... params) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.WARN, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }

    @Override
    public void info(String s, Object ... params) {
        Throwable throwable = null;
        this.log.logIfEnabled(FQCN, Level.INFO, MARKER, LogUtil.getLogInfo(s, params), throwable);
    }
}

