/*
 * Decompiled with CFR 0.152.
 */
package net.alchim31.maven.yuicompressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.alchim31.maven.yuicompressor.Aggregation;
import net.alchim31.maven.yuicompressor.MojoSupport;
import net.alchim31.maven.yuicompressor.SourceFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;

@Mojo(name="compress", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true, threadSafe=true)
public class YuiCompressorMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.build.sourceEncoding}", property="file.encoding")
    private String encoding;
    @Parameter(defaultValue="-min", property="maven.yuicompressor.suffix")
    private String suffix;
    @Parameter(defaultValue="false", property="maven.yuicompressor.nosuffix")
    private boolean nosuffix;
    @Parameter(defaultValue="-1", property="maven.yuicompressor.linebreakpos")
    private int linebreakpos;
    @Parameter(defaultValue="false", property="maven.yuicompressor.nocompress")
    private boolean nocompress;
    @Parameter(defaultValue="false", property="maven.yuicompressor.nomunge")
    private boolean nomunge;
    @Parameter(defaultValue="false", property="maven.yuicompressor.preserveAllSemiColons")
    private boolean preserveAllSemiColons;
    @Parameter(defaultValue="false", property="maven.yuicompressor.disableOptimizations")
    private boolean disableOptimizations;
    @Parameter(defaultValue="false", property="maven.yuicompressor.force")
    private boolean force;
    @Parameter
    private Aggregation[] aggregations;
    @Parameter(defaultValue="false", property="maven.yuicompressor.gzip")
    private boolean gzip;
    @Parameter(defaultValue="9", property="maven.yuicompressor.level")
    private int level;
    @Parameter(defaultValue="true", property="maven.yuicompressor.statistics")
    private boolean statistics;
    @Parameter(defaultValue="false", property="maven.yuicompressor.preProcessAggregates")
    private boolean preProcessAggregates;
    @Parameter(defaultValue="true", property="maven.yuicompressor.useSmallestFile")
    private boolean useSmallestFile;
    private long inSizeTotal;
    private long outSizeTotal;
    private Set<String> incrementalFiles;

    @Override
    protected String[] getDefaultIncludes() {
        return new String[]{"**/*.css", "**/*.js"};
    }

    @Override
    public void beforeProcess() throws IOException {
        if (this.nosuffix) {
            this.suffix = "";
        }
        if (this.preProcessAggregates) {
            this.aggregate();
        }
    }

    @Override
    protected void afterProcess() throws IOException {
        if (this.statistics && this.inSizeTotal > 0L) {
            this.getLog().info((CharSequence)String.format("total input (%db) -> output (%db)[%d%%]", this.inSizeTotal, this.outSizeTotal, this.outSizeTotal * 100L / this.inSizeTotal));
        }
        if (!this.preProcessAggregates) {
            this.aggregate();
        }
    }

    private void aggregate() throws IOException {
        if (this.aggregations != null) {
            HashSet<File> previouslyIncludedFiles = new HashSet<File>();
            for (Aggregation aggregation : this.aggregations) {
                this.getLog().info((CharSequence)("generate aggregation : " + aggregation.getOutput()));
                List<File> aggregatedFiles = aggregation.run(previouslyIncludedFiles, this.buildContext, this.incrementalFiles);
                previouslyIncludedFiles.addAll(aggregatedFiles);
                File gzipped = this.gzipIfRequested(aggregation.getOutput());
                if (!this.statistics) continue;
                if (gzipped != null) {
                    this.getLog().info((CharSequence)String.format("%s (%db) -> %s (%db)[%d%%]", aggregation.getOutput().getName(), aggregation.getOutput().length(), gzipped.getName(), gzipped.length(), this.ratioOfSize(aggregation.getOutput(), gzipped)));
                    continue;
                }
                if (aggregation.getOutput().exists()) {
                    this.getLog().info((CharSequence)String.format("%s (%db)", aggregation.getOutput().getName(), aggregation.getOutput().length()));
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("%s not created", aggregation.getOutput().getName()));
            }
        }
    }

    @Override
    protected void processFile(SourceFile src) throws IOException, MojoExecutionException {
        boolean outputIgnored;
        File inFile = src.toFile();
        this.getLog().debug((CharSequence)"on incremental build only compress if input file has Delta");
        if (this.buildContext.isIncremental()) {
            if (!this.buildContext.hasDelta(inFile)) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("nothing to do, " + inFile + " has no Delta"));
                }
                return;
            }
            if (this.incrementalFiles == null) {
                this.incrementalFiles = new HashSet<String>();
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("compress file :" + src.toFile() + " to " + src.toDestFile(this.suffix)));
        }
        File outFile = src.toDestFile(this.suffix);
        if (!this.nosuffix && this.isMinifiedFile(inFile)) {
            return;
        }
        this.getLog().debug((CharSequence)"only compress if input file is younger than existing output file");
        if (!this.force && outFile.exists() && outFile.lastModified() > inFile.lastModified()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("nothing to do, " + outFile + " is younger than original, use 'force' option or clean your target"));
            }
            return;
        }
        File outFileTmp = new File(outFile.getCanonicalFile() + ".tmp");
        FileUtils.forceDelete((File)outFileTmp);
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Cannot create resource output directory: " + outFile.getParentFile());
        }
        this.getLog().debug((CharSequence)"use a temporary outputfile (in case in == out)");
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(inFile), Charset.forName(this.encoding));
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFileTmp), Charset.forName(this.encoding));){
            this.getLog().debug((CharSequence)"start compression");
            if (this.nocompress) {
                this.getLog().info((CharSequence)"No compression is enabled");
                IOUtil.copy((Reader)in, (Writer)out);
            } else if (".js".equalsIgnoreCase(src.getExtension())) {
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, (ErrorReporter)this.jsErrorReporter);
                compressor.compress((Writer)out, this.linebreakpos, !this.nomunge, this.jswarn, this.preserveAllSemiColons, this.disableOptimizations);
            } else if (".css".equalsIgnoreCase(src.getExtension())) {
                this.compressCss(in, out);
            }
            this.getLog().debug((CharSequence)"end compression");
        }
        boolean bl = outputIgnored = this.useSmallestFile && inFile.length() < outFile.length();
        if (outputIgnored) {
            FileUtils.forceDelete((File)outFileTmp);
            FileUtils.copyFile((File)inFile, (File)outFile);
            this.getLog().debug((CharSequence)"output greater than input, using original instead");
        } else {
            FileUtils.forceDelete((File)outFile);
            FileUtils.rename((File)outFileTmp, (File)outFile);
            this.buildContext.refresh(outFile);
        }
        if (this.buildContext.isIncremental()) {
            this.incrementalFiles.add(outFile.getCanonicalPath());
        }
        File gzipped = this.gzipIfRequested(outFile);
        if (this.statistics) {
            this.inSizeTotal += inFile.length();
            this.outSizeTotal += outFile.length();
            String fileStatistics = outputIgnored ? String.format("%s (%db) -> %s (%db)[compressed output discarded (exceeded input size)]", inFile.getName(), inFile.length(), outFile.getName(), outFile.length()) : String.format("%s (%db) -> %s (%db)[%d%%]", inFile.getName(), inFile.length(), outFile.getName(), outFile.length(), this.ratioOfSize(inFile, outFile));
            if (gzipped != null) {
                fileStatistics = fileStatistics + String.format(" -> %s (%db)[%d%%]", gzipped.getName(), gzipped.length(), this.ratioOfSize(inFile, gzipped));
            }
            this.getLog().info((CharSequence)fileStatistics);
        }
    }

    private void compressCss(InputStreamReader in, OutputStreamWriter out) throws IOException {
        try {
            CssCompressor compressor = new CssCompressor((Reader)in);
            compressor.compress((Writer)out, this.linebreakpos);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unexpected characters found in CSS file. Ensure that the CSS file does not contain '$', and try again", e);
        }
    }

    protected File gzipIfRequested(File file) throws IOException {
        if (!this.gzip || file == null || !file.exists() || ".gz".equalsIgnoreCase(FileUtils.getExtension((String)file.getName()))) {
            return null;
        }
        File gzipped = new File(file.getCanonicalPath() + ".gz");
        this.getLog().debug((CharSequence)String.format("create gzip version : %s", gzipped.getName()));
        try (FileInputStream in = new FileInputStream(file);
             GZIPOutputStream out = new GZIPOutputStream(this.buildContext.newFileOutputStream(gzipped)){
            {
                this.def.setLevel(YuiCompressorMojo.this.level);
            }
        };){
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        return gzipped;
    }

    protected long ratioOfSize(File file100, File fileX) {
        long v100 = Math.max(file100.length(), 1L);
        long vX = Math.max(fileX.length(), 1L);
        return vX * 100L / v100;
    }

    private boolean isMinifiedFile(File inFile) {
        String filename = inFile.getName().toLowerCase(Locale.getDefault());
        return filename.endsWith(this.suffix + ".js") || filename.endsWith(this.suffix + ".css");
    }
}

