/*
 * Decompiled with CFR 0.152.
 */
package net.alchim31.maven.yuicompressor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.alchim31.maven.yuicompressor.ErrorReporter4Mojo;
import net.alchim31.maven.yuicompressor.SourceFile;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.build.BuildContext;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;

public abstract class MojoSupport
extends AbstractMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @Parameter(defaultValue="${project.build.sourceDirectory}/../js")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.basedir}/src/main/webapp")
    private File warSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    private File webappDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.resources}", required=true, readonly=true)
    private List<Resource> resources;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="false")
    private boolean useProcessedResources;
    @Parameter
    private List<String> includes;
    @Parameter
    private boolean excludeWarSourceDirectory;
    @Parameter(defaultValue="false")
    private boolean excludeResources;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="true", property="maven.yuicompressor.jswarn")
    protected boolean jswarn;
    @Parameter(defaultValue="false", property="maven.yuicompressor.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="maven.yuicompressor.failOnWarning")
    protected boolean failOnWarning;
    @Component
    protected BuildContext buildContext;
    protected ErrorReporter4Mojo jsErrorReporter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"run of yuicompressor-maven-plugin skipped");
            return;
        }
        if (this.failOnWarning) {
            this.jswarn = true;
        }
        this.jsErrorReporter = new ErrorReporter4Mojo(this.getLog(), this.jswarn, this.buildContext);
        try {
            this.beforeProcess();
            this.processDir(this.sourceDirectory, this.outputDirectory, null, this.useProcessedResources);
            if (!this.excludeResources) {
                for (Resource resource : this.resources) {
                    File destRoot = this.outputDirectory;
                    if (resource.getTargetPath() != null) {
                        destRoot = new File(this.outputDirectory, resource.getTargetPath());
                    }
                    this.processDir(new File(resource.getDirectory()), destRoot, resource.getExcludes(), this.useProcessedResources);
                }
            }
            if (!this.excludeWarSourceDirectory) {
                this.processDir(this.warSourceDirectory, this.webappDirectory, null, this.useProcessedResources);
            }
            this.afterProcess();
        }
        catch (Exception e) {
            throw new MojoExecutionException("wrap: " + e.getMessage(), e);
        }
        this.getLog().info((CharSequence)String.format("nb warnings: %d, nb errors: %d", this.jsErrorReporter.getWarningCnt(), this.jsErrorReporter.getErrorCnt()));
        if (this.failOnWarning && this.jsErrorReporter.getWarningCnt() > 0) {
            throw new MojoFailureException("warnings on " + ((Object)((Object)this)).getClass().getSimpleName() + "=> failure ! (see log)");
        }
    }

    protected abstract String[] getDefaultIncludes();

    protected abstract void beforeProcess() throws IOException;

    protected abstract void afterProcess() throws IOException;

    private void processDir(File srcRoot, File destRoot, List<String> srcExcludes, boolean destAsSource) throws IOException, MojoFailureException, MojoExecutionException {
        Scanner scanner;
        if (srcRoot == null) {
            return;
        }
        if (!srcRoot.exists()) {
            this.buildContext.addMessage(srcRoot, 0, 0, "Directory " + srcRoot.getPath() + " does not exist", 1, null);
            this.getLog().info((CharSequence)("Directory " + srcRoot.getPath() + " does not exist"));
            return;
        }
        if (destRoot == null) {
            throw new MojoFailureException("destination directory for " + srcRoot + " is null");
        }
        if (!this.buildContext.isIncremental()) {
            DirectoryScanner dScanner = new DirectoryScanner();
            dScanner.setBasedir(srcRoot);
            scanner = dScanner;
        } else {
            scanner = this.buildContext.newScanner(srcRoot);
        }
        if (this.includes == null) {
            scanner.setIncludes(this.getDefaultIncludes());
        } else {
            scanner.setIncludes(this.includes.toArray(new String[0]));
        }
        if (srcExcludes != null && !srcExcludes.isEmpty()) {
            scanner.setExcludes(srcExcludes.toArray(EMPTY_STRING_ARRAY));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            scanner.setExcludes(this.excludes.toArray(EMPTY_STRING_ARRAY));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        if (includedFiles == null || includedFiles.length == 0) {
            if (this.buildContext.isIncremental()) {
                this.getLog().info((CharSequence)"No files have changed, so skipping the processing");
            } else {
                this.getLog().info((CharSequence)"No files to be processed");
            }
            return;
        }
        for (String name : includedFiles) {
            SourceFile src = new SourceFile(srcRoot, destRoot, name, destAsSource);
            this.jsErrorReporter.setDefaultFileName("..." + src.toFile().getCanonicalPath().substring(src.toFile().getCanonicalPath().lastIndexOf(47) + 1));
            this.jsErrorReporter.setFile(src.toFile());
            this.processFile(src);
        }
    }

    protected abstract void processFile(SourceFile var1) throws IOException, MojoExecutionException;
}

