/*
 * Decompiled with CFR 0.152.
 */
package net.alchim31.maven.yuicompressor;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.build.BuildContext;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class ErrorReporter4Mojo
implements ErrorReporter {
    private String defaultFilename;
    private boolean acceptWarn;
    private Log log;
    private int warningCnt;
    private int errorCnt;
    private BuildContext buildContext;
    private File sourceFile;

    public ErrorReporter4Mojo(Log log, boolean jswarn, BuildContext buildContext) {
        this.log = log;
        this.acceptWarn = jswarn;
        this.buildContext = buildContext;
    }

    public void setDefaultFileName(String v) {
        if (v.length() == 0) {
            v = null;
        }
        this.defaultFilename = v;
    }

    public int getErrorCnt() {
        return this.errorCnt;
    }

    public int getWarningCnt() {
        return this.warningCnt;
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        String fullMessage = this.newMessage(message, sourceName, line, lineSource, lineOffset);
        this.buildContext.addMessage(this.sourceFile, line, lineOffset, message, 2, null);
        this.log.error((CharSequence)fullMessage);
        ++this.errorCnt;
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        throw new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.acceptWarn) {
            String fullMessage = this.newMessage(message, sourceName, line, lineSource, lineOffset);
            this.buildContext.addMessage(this.sourceFile, line, lineOffset, message, 1, null);
            this.log.warn((CharSequence)fullMessage);
            ++this.warningCnt;
        }
    }

    private String newMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
        StringBuilder back = new StringBuilder();
        if (sourceName == null || sourceName.length() == 0) {
            sourceName = this.defaultFilename;
        }
        if (sourceName != null) {
            back.append(sourceName).append(":line ").append(line).append(":column ").append(lineOffset).append(':');
        }
        if (message != null && message.length() != 0) {
            back.append(message);
        } else {
            back.append("unknown error");
        }
        if (lineSource != null && lineSource.length() != 0) {
            back.append("\n\t").append(lineSource);
        }
        return back.toString();
    }

    public void setFile(File file) {
        this.sourceFile = file;
    }
}

