/*
 * Decompiled with CFR 0.152.
 */
package net.alchim31.maven.yuicompressor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRhinoShell
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BasicRhinoShell.class);
    private boolean quitting;

    public String getClassName() {
        return "global";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exec(String[] args, ErrorReporter reporter) {
        Context cx = Context.enter();
        cx.setErrorReporter(reporter);
        try {
            Object[] array;
            BasicRhinoShell basicRhinoShell = new BasicRhinoShell();
            cx.initStandardObjects((ScriptableObject)basicRhinoShell);
            String[] names = new String[]{"print", "quit", "version", "load", "help", "readFile", "warn"};
            basicRhinoShell.defineFunctionProperties(names, BasicRhinoShell.class, 2);
            args = BasicRhinoShell.processOptions(cx, args);
            if (args.length == 0) {
                array = new Object[]{};
            } else {
                int length = args.length - 1;
                array = new Object[length];
                System.arraycopy(args, 1, array, 0, length);
            }
            Scriptable argsObj = cx.newArray((Scriptable)basicRhinoShell, array);
            basicRhinoShell.defineProperty("arguments", argsObj, 2);
            basicRhinoShell.processSource(cx, args.length == 0 ? null : args[0]);
        }
        finally {
            Context.exit();
        }
    }

    public static String[] processOptions(Context cx, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                String[] result = new String[args.length - i];
                for (int j = i; j < args.length; ++j) {
                    result[j - i] = args[j];
                }
                return result;
            }
            if (arg.equals("-version")) {
                double d;
                if (++i == args.length) {
                    BasicRhinoShell.usage(arg);
                }
                if (Double.isNaN(d = Context.toNumber((Object)args[i]))) {
                    BasicRhinoShell.usage(arg);
                }
                cx.setLanguageVersion((int)d);
                continue;
            }
            BasicRhinoShell.usage(arg);
        }
        return new String[0];
    }

    private static void usage(String s) {
        BasicRhinoShell.p("Didn't understand \"" + s + "\".");
        BasicRhinoShell.p("Valid arguments are:");
        BasicRhinoShell.p("-version 100|110|120|130|140|150|160|170");
        System.exit(1);
    }

    public void help() {
        BasicRhinoShell.p("");
        BasicRhinoShell.p("Command                Description");
        BasicRhinoShell.p("=======                ===========");
        BasicRhinoShell.p("help()                 Display usage and help messages. ");
        BasicRhinoShell.p("defineClass(className) Define an extension using the Java class");
        BasicRhinoShell.p("                       named with the string argument. ");
        BasicRhinoShell.p("                       Uses ScriptableObject.defineClass(). ");
        BasicRhinoShell.p("load(['foo.js', ...])  Load JavaScript source files named by ");
        BasicRhinoShell.p("                       string arguments. ");
        BasicRhinoShell.p("loadClass(className)   Load a class named by a string argument.");
        BasicRhinoShell.p("                       The class must be a script compiled to a");
        BasicRhinoShell.p("                       class file. ");
        BasicRhinoShell.p("print([expr ...])      Evaluate and print expressions. ");
        BasicRhinoShell.p("quit()                 Quit the BasicRhinoShell. ");
        BasicRhinoShell.p("version([number])      Get or set the JavaScript version number.");
        BasicRhinoShell.p("");
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                logger.info("");
            }
            String s = Context.toString((Object)args[i]);
            logger.info(s);
        }
        logger.info("");
    }

    public void quit() {
        this.quitting = true;
    }

    public static void warn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String message = Context.toString((Object)args[0]);
        int line = (int)Context.toNumber((Object)args[1]);
        String source = Context.toString((Object)args[2]);
        int column = (int)Context.toNumber((Object)args[3]);
        cx.getErrorReporter().warning(message, null, line, source, column);
    }

    public String readFile(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new RuntimeException("wrap: " + exc.getMessage(), exc);
        }
    }

    public static double version(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double result = cx.getLanguageVersion();
        if (args.length > 0) {
            double d = Context.toNumber((Object)args[0]);
            cx.setLanguageVersion((int)d);
        }
        return result;
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        BasicRhinoShell basicRhinoShell = (BasicRhinoShell)BasicRhinoShell.getTopLevelScope((Scriptable)thisObj);
        for (Object element : args) {
            basicRhinoShell.processSource(cx, Context.toString((Object)element));
        }
    }

    private void processSource(Context cx, String filename) {
        if (filename == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            String sourceName = "<stdin>";
            int lineno = 1;
            boolean hitEOF = false;
            do {
                int startline = lineno;
                logger.info("js> ");
                try {
                    StringBuilder source = new StringBuilder();
                    do {
                        String newline;
                        if ((newline = in.readLine()) == null) {
                            hitEOF = true;
                            break;
                        }
                        source.append(newline).append("\n");
                        ++lineno;
                    } while (!cx.stringIsCompilableUnit(source.toString()));
                    Object result = cx.evaluateString((Scriptable)this, source.toString(), sourceName, startline, null);
                    if (result == Context.getUndefinedValue() || !logger.isInfoEnabled()) continue;
                    logger.info("{}", (Object)Context.toString((Object)result));
                }
                catch (WrappedException e) {
                    logger.info(e.getWrappedException().toString());
                    logger.error("", (Throwable)e);
                }
                catch (EvaluatorException | JavaScriptException e) {
                    logger.info("js: {}", (Object)e.getMessage());
                }
                catch (IOException e) {
                    logger.info(e.toString());
                }
            } while (!this.quitting && !hitEOF);
            logger.info("");
        } else {
            try (BufferedReader in = Files.newBufferedReader(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);){
                cx.evaluateReader((Scriptable)this, (Reader)in, filename, 1, null);
            }
            catch (WrappedException e) {
                logger.info(e.getWrappedException().toString());
                logger.error("", (Throwable)e);
            }
            catch (EvaluatorException | JavaScriptException e) {
                logger.info("js: {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    private static void p(String s) {
        logger.info(s);
    }
}

