/*
 * Decompiled with CFR 0.152.
 */
package net.alchim31.maven.yuicompressor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.build.BuildContext;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

public class Aggregation {
    private File inputDir;
    private File output;
    private String[] includes;
    private String[] excludes;
    private boolean removeIncluded;
    private boolean insertNewLine;
    private boolean insertFileHeader;
    private boolean fixLastSemicolon;
    private boolean autoExcludeWildcards;

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setInsertNewLine(boolean insertNewLine) {
        this.insertNewLine = insertNewLine;
    }

    public void setAutoExcludeWildcards(boolean autoExcludeWildcards) {
        this.autoExcludeWildcards = autoExcludeWildcards;
    }

    public List<File> run(Collection<File> previouslyIncludedFiles, BuildContext buildContext) throws IOException {
        return this.run(previouslyIncludedFiles, buildContext, null);
    }

    public List<File> run(Collection<File> previouslyIncludedFiles, BuildContext buildContext, Set<String> incrementalFiles) throws IOException {
        this.defineInputDir();
        List<File> files = this.autoExcludeWildcards ? this.getIncludedFiles(previouslyIncludedFiles, buildContext, incrementalFiles) : this.getIncludedFiles(null, buildContext, incrementalFiles);
        if (!files.isEmpty()) {
            this.output = this.output.getCanonicalFile();
            this.output.getParentFile().mkdirs();
            try (OutputStream out = buildContext.newFileOutputStream(this.output);){
                for (File file : files) {
                    if (file.getCanonicalPath().equals(this.output.getCanonicalPath())) continue;
                    try (FileInputStream in = new FileInputStream(file);){
                        if (this.insertFileHeader) {
                            out.write(this.createFileHeader(file).getBytes(StandardCharsets.UTF_8));
                        }
                        IOUtil.copy((InputStream)in, (OutputStream)out);
                        if (this.fixLastSemicolon) {
                            out.write(59);
                        }
                        if (this.insertNewLine) {
                            out.write(10);
                        }
                    }
                    if (!this.removeIncluded) continue;
                    if (file.exists()) {
                        Files.delete(file.toPath());
                    }
                    buildContext.refresh(file);
                }
            }
        }
        return files;
    }

    private String createFileHeader(File file) {
        StringBuilder header = new StringBuilder();
        header.append("/*");
        header.append(file.getName());
        header.append("*/");
        if (this.insertNewLine) {
            header.append('\n');
        }
        return header.toString();
    }

    private void defineInputDir() throws IOException {
        if (this.inputDir == null) {
            this.inputDir = this.output.getParentFile();
        }
        this.inputDir = this.inputDir.getCanonicalFile();
        if (!this.inputDir.isDirectory()) {
            throw new IllegalStateException("input directory not found: " + this.inputDir);
        }
    }

    private List<File> getIncludedFiles(Collection<File> previouslyIncludedFiles, BuildContext buildContext, Set<String> incrementalFiles) throws IOException {
        ArrayList<File> filesToAggregate = new ArrayList<File>();
        if (this.includes != null) {
            for (String include : this.includes) {
                this.addInto(include, filesToAggregate, previouslyIncludedFiles);
            }
        }
        if (!buildContext.isIncremental()) {
            return filesToAggregate;
        }
        if (incrementalFiles != null) {
            boolean aggregateMustBeUpdated = false;
            for (File file : filesToAggregate) {
                if (!incrementalFiles.contains(file.getCanonicalPath())) continue;
                aggregateMustBeUpdated = true;
                break;
            }
            if (aggregateMustBeUpdated) {
                return filesToAggregate;
            }
        }
        return new ArrayList<File>();
    }

    private void addInto(String include, List<File> includedFiles, Collection<File> previouslyIncludedFiles) {
        if (include.indexOf(42) > -1) {
            DirectoryScanner scanner = this.newScanner();
            scanner.setIncludes(new String[]{include});
            scanner.scan();
            Object[] rpaths = scanner.getIncludedFiles();
            Arrays.sort(rpaths);
            for (Object rpath : rpaths) {
                File file = new File(scanner.getBasedir(), (String)rpath);
                if (includedFiles.contains(file) || previouslyIncludedFiles != null && previouslyIncludedFiles.contains(file)) continue;
                includedFiles.add(file);
            }
        } else {
            File file = new File(include);
            if (!file.isAbsolute()) {
                file = new File(this.inputDir, include);
            }
            if (!includedFiles.contains(file)) {
                includedFiles.add(file);
            }
        }
    }

    private DirectoryScanner newScanner() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.inputDir);
        if (this.excludes != null && this.excludes.length != 0) {
            scanner.setExcludes(this.excludes);
        }
        scanner.addDefaultExcludes();
        return scanner;
    }
}

