/* Copyright 2013 Samuel Halliday (generated Java and C).
 * Copyright 2003-2007 Keith Seymour (Fortran to Java translation).
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <jni.h>
#include <netlib-jni.h>
#include <cblas.h>
#include <com_github_fommil_netlib_NativeSystemBLAS.h>

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dasum (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint incx) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble returnValue = cblas_dasum(n, jni_dx, incx);
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dasum_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint _dx_offset, jint incx) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble returnValue = cblas_dasum(n, jni_dx + _dx_offset, incx);
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
  return returnValue;
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_daxpy (JNIEnv * env, jobject calling_obj, jint n, jdouble da, jdoubleArray dx, jint incx, jdoubleArray dy, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_daxpy(n, da, jni_dx, incx, jni_dy, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_daxpy_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdouble da, jdoubleArray dx, jint _dx_offset, jint incx, jdoubleArray dy, jint _dy_offset, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_daxpy(n, da, jni_dx + _dx_offset, incx, jni_dy + _dy_offset, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dcopy (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint incx, jdoubleArray dy, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_dcopy(n, jni_dx, incx, jni_dy, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dcopy_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint _dx_offset, jint incx, jdoubleArray dy, jint _dy_offset, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_dcopy(n, jni_dx + _dx_offset, incx, jni_dy + _dy_offset, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ddot (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint incx, jdoubleArray dy, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
  jdouble returnValue = cblas_ddot(n, jni_dx, incx, jni_dy, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ddot_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint _dx_offset, jint incx, jdoubleArray dy, jint _dy_offset, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
  jdouble returnValue = cblas_ddot(n, jni_dx + _dx_offset, incx, jni_dy + _dy_offset, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
  return returnValue;
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dgbmv (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint kl, jint ku, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray x, jint incx, jdouble beta, jdoubleArray y, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dgbmv(CblasColMajor, getCblasTrans(jni_trans), m, n, kl, ku, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dgbmv_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint kl, jint ku, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx, jdouble beta, jdoubleArray y, jint _y_offset, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dgbmv(CblasColMajor, getCblasTrans(jni_trans), m, n, kl, ku, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dgemm (JNIEnv * env, jobject calling_obj, jstring transa, jstring transb, jint m, jint n, jint k, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble beta, jdoubleArray c, jint Ldc) {
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_transb = (char *)(*env)->GetStringUTFChars(env, transb, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dgemm(CblasColMajor, getCblasTrans(jni_transa), getCblasTrans(jni_transb), m, n, k, alpha, jni_a, lda, jni_b, ldb, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, transb, jni_transb);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dgemm_1offsets (JNIEnv * env, jobject calling_obj, jstring transa, jstring transb, jint m, jint n, jint k, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdouble beta, jdoubleArray c, jint _c_offset, jint Ldc) {
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_transb = (char *)(*env)->GetStringUTFChars(env, transb, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dgemm(CblasColMajor, getCblasTrans(jni_transa), getCblasTrans(jni_transb), m, n, k, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, transb, jni_transb);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dgemv (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray x, jint incx, jdouble beta, jdoubleArray y, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dgemv(CblasColMajor, getCblasTrans(jni_trans), m, n, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dgemv_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx, jdouble beta, jdoubleArray y, jint _y_offset, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dgemv(CblasColMajor, getCblasTrans(jni_trans), m, n, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dger (JNIEnv * env, jobject calling_obj, jint m, jint n, jdouble alpha, jdoubleArray x, jint incx, jdoubleArray y, jint incy, jdoubleArray a, jint lda) {
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_dger(CblasColMajor, m, n, alpha, jni_x, incx, jni_y, incy, jni_a, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dger_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jdouble alpha, jdoubleArray x, jint _x_offset, jint incx, jdoubleArray y, jint _y_offset, jint incy, jdoubleArray a, jint _a_offset, jint lda) {
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_dger(CblasColMajor, m, n, alpha, jni_x + _x_offset, incx, jni_y + _y_offset, incy, jni_a + _a_offset, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dnrm2 (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray x, jint incx) {
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble returnValue = cblas_dnrm2(n, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  return returnValue;
}

JNIEXPORT jdouble JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dnrm2_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray x, jint _x_offset, jint incx) {
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble returnValue = cblas_dnrm2(n, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  return returnValue;
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_drot (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint incx, jdoubleArray dy, jint incy, jdouble c, jdouble s) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_drot(n, jni_dx, incx, jni_dy, incy, c, s);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_drot_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint _dx_offset, jint incx, jdoubleArray dy, jint _dy_offset, jint incy, jdouble c, jdouble s) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_drot(n, jni_dx + _dx_offset, incx, jni_dy + _dy_offset, incy, c, s);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_drotg (JNIEnv * env, jobject calling_obj, jdoublew da, jdoublew db, jdoublew c, jdoublew s) {
  jclass jni_daClass = (*env)->GetObjectClass(env, da);
  jfieldID jni_daId = (*env)->GetFieldID(env, jni_daClass, "val", "D");
  jdouble jni_da = (*env)->GetDoubleField(env, da, jni_daId);
  jclass jni_dbClass = (*env)->GetObjectClass(env, db);
  jfieldID jni_dbId = (*env)->GetFieldID(env, jni_dbClass, "val", "D");
  jdouble jni_db = (*env)->GetDoubleField(env, db, jni_dbId);
  jclass jni_cClass = (*env)->GetObjectClass(env, c);
  jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
  jdouble jni_c = (*env)->GetDoubleField(env, c, jni_cId);
  jclass jni_sClass = (*env)->GetObjectClass(env, s);
  jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
  jdouble jni_s = (*env)->GetDoubleField(env, s, jni_sId);
cblas_drotg(&jni_da, &jni_db, &jni_c, &jni_s);
  (*env)->SetDoubleField(env, s, jni_sId, jni_s);
  (*env)->SetDoubleField(env, c, jni_cId, jni_c);
  (*env)->SetDoubleField(env, db, jni_dbId, jni_db);
  (*env)->SetDoubleField(env, da, jni_daId, jni_da);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_drotm (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint incx, jdoubleArray dy, jint incy, jdoubleArray dparam) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
  jdouble * jni_dparam = NULL;
  if (dparam != NULL) {
    jni_dparam = (*env)->GetPrimitiveArrayCritical(env, dparam, JNI_FALSE);
    check_memory(env, jni_dparam);
  }
cblas_drotm(n, jni_dx, incx, jni_dy, incy, jni_dparam);
  if (dparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dparam, jni_dparam, 0);
  }
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_drotm_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint _dx_offset, jint incx, jdoubleArray dy, jint _dy_offset, jint incy, jdoubleArray dparam, jint _dparam_offset) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
  jdouble * jni_dparam = NULL;
  if (dparam != NULL) {
    jni_dparam = (*env)->GetPrimitiveArrayCritical(env, dparam, JNI_FALSE);
    check_memory(env, jni_dparam);
  }
cblas_drotm(n, jni_dx + _dx_offset, incx, jni_dy + _dy_offset, incy, jni_dparam + _dparam_offset);
  if (dparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dparam, jni_dparam, 0);
  }
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_drotmg (JNIEnv * env, jobject calling_obj, jdoublew dd1, jdoublew dd2, jdoublew dx1, jdouble dy1, jdoubleArray dparam) {
  jclass jni_dd1Class = (*env)->GetObjectClass(env, dd1);
  jfieldID jni_dd1Id = (*env)->GetFieldID(env, jni_dd1Class, "val", "D");
  jdouble jni_dd1 = (*env)->GetDoubleField(env, dd1, jni_dd1Id);
  jclass jni_dd2Class = (*env)->GetObjectClass(env, dd2);
  jfieldID jni_dd2Id = (*env)->GetFieldID(env, jni_dd2Class, "val", "D");
  jdouble jni_dd2 = (*env)->GetDoubleField(env, dd2, jni_dd2Id);
  jclass jni_dx1Class = (*env)->GetObjectClass(env, dx1);
  jfieldID jni_dx1Id = (*env)->GetFieldID(env, jni_dx1Class, "val", "D");
  jdouble jni_dx1 = (*env)->GetDoubleField(env, dx1, jni_dx1Id);
  jdouble * jni_dparam = NULL;
  if (dparam != NULL) {
    jni_dparam = (*env)->GetPrimitiveArrayCritical(env, dparam, JNI_FALSE);
    check_memory(env, jni_dparam);
  }
cblas_drotmg(&jni_dd1, &jni_dd2, &jni_dx1, dy1, jni_dparam);
  if (dparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dparam, jni_dparam, 0);
  }
  (*env)->SetDoubleField(env, dx1, jni_dx1Id, jni_dx1);
  (*env)->SetDoubleField(env, dd2, jni_dd2Id, jni_dd2);
  (*env)->SetDoubleField(env, dd1, jni_dd1Id, jni_dd1);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_drotmg_1offsets (JNIEnv * env, jobject calling_obj, jdoublew dd1, jdoublew dd2, jdoublew dx1, jdouble dy1, jdoubleArray dparam, jint _dparam_offset) {
  jclass jni_dd1Class = (*env)->GetObjectClass(env, dd1);
  jfieldID jni_dd1Id = (*env)->GetFieldID(env, jni_dd1Class, "val", "D");
  jdouble jni_dd1 = (*env)->GetDoubleField(env, dd1, jni_dd1Id);
  jclass jni_dd2Class = (*env)->GetObjectClass(env, dd2);
  jfieldID jni_dd2Id = (*env)->GetFieldID(env, jni_dd2Class, "val", "D");
  jdouble jni_dd2 = (*env)->GetDoubleField(env, dd2, jni_dd2Id);
  jclass jni_dx1Class = (*env)->GetObjectClass(env, dx1);
  jfieldID jni_dx1Id = (*env)->GetFieldID(env, jni_dx1Class, "val", "D");
  jdouble jni_dx1 = (*env)->GetDoubleField(env, dx1, jni_dx1Id);
  jdouble * jni_dparam = NULL;
  if (dparam != NULL) {
    jni_dparam = (*env)->GetPrimitiveArrayCritical(env, dparam, JNI_FALSE);
    check_memory(env, jni_dparam);
  }
cblas_drotmg(&jni_dd1, &jni_dd2, &jni_dx1, dy1, jni_dparam + _dparam_offset);
  if (dparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dparam, jni_dparam, 0);
  }
  (*env)->SetDoubleField(env, dx1, jni_dx1Id, jni_dx1);
  (*env)->SetDoubleField(env, dd2, jni_dd2Id, jni_dd2);
  (*env)->SetDoubleField(env, dd1, jni_dd1Id, jni_dd1);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsbmv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint k, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray x, jint incx, jdouble beta, jdoubleArray y, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dsbmv(CblasColMajor, getCblasUpLo(jni_uplo), n, k, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsbmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint k, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx, jdouble beta, jdoubleArray y, jint _y_offset, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dsbmv(CblasColMajor, getCblasUpLo(jni_uplo), n, k, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dscal (JNIEnv * env, jobject calling_obj, jint n, jdouble da, jdoubleArray dx, jint incx) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
cblas_dscal(n, da, jni_dx, incx);
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dscal_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdouble da, jdoubleArray dx, jint _dx_offset, jint incx) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
cblas_dscal(n, da, jni_dx + _dx_offset, incx);
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dspmv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray ap, jdoubleArray x, jint incx, jdouble beta, jdoubleArray y, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dspmv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_ap, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dspmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray ap, jint _ap_offset, jdoubleArray x, jint _x_offset, jint incx, jdouble beta, jdoubleArray y, jint _y_offset, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dspmv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_ap + _ap_offset, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dspr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint incx, jdoubleArray ap) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_dspr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_ap);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dspr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint _x_offset, jint incx, jdoubleArray ap, jint _ap_offset) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_dspr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_ap + _ap_offset);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dspr2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint incx, jdoubleArray y, jint incy, jdoubleArray ap) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_dspr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_y, incy, jni_ap);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dspr2_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint _x_offset, jint incx, jdoubleArray y, jint _y_offset, jint incy, jdoubleArray ap, jint _ap_offset) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_dspr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_y + _y_offset, incy, jni_ap + _ap_offset);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dswap (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint incx, jdoubleArray dy, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_dswap(n, jni_dx, incx, jni_dy, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dswap_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint _dx_offset, jint incx, jdoubleArray dy, jint _dy_offset, jint incy) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jdouble * jni_dy = NULL;
  if (dy != NULL) {
    jni_dy = (*env)->GetPrimitiveArrayCritical(env, dy, JNI_FALSE);
    check_memory(env, jni_dy);
  }
cblas_dswap(n, jni_dx + _dx_offset, incx, jni_dy + _dy_offset, incy);
  if (dy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dy, jni_dy, 0);
  }
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsymm (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jint m, jint n, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble beta, jdoubleArray c, jint Ldc) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dsymm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), m, n, alpha, jni_a, lda, jni_b, ldb, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsymm_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jint m, jint n, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdouble beta, jdoubleArray c, jint _c_offset, jint Ldc) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dsymm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), m, n, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsymv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray x, jint incx, jdouble beta, jdoubleArray y, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dsymv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsymv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx, jdouble beta, jdoubleArray y, jint _y_offset, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_dsymv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint incx, jdoubleArray a, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_dsyr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_a, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint _x_offset, jint incx, jdoubleArray a, jint _a_offset, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_dsyr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_a + _a_offset, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyr2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint incx, jdoubleArray y, jint incy, jdoubleArray a, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_dsyr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_y, incy, jni_a, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyr2_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdouble alpha, jdoubleArray x, jint _x_offset, jint incx, jdoubleArray y, jint _y_offset, jint incy, jdoubleArray a, jint _a_offset, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jdouble * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_dsyr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_y + _y_offset, incy, jni_a + _a_offset, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyr2k (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble beta, jdoubleArray c, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dsyr2k(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a, lda, jni_b, ldb, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyr2k_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb, jdouble beta, jdoubleArray c, jint _c_offset, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dsyr2k(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyrk (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jdouble alpha, jdoubleArray a, jint lda, jdouble beta, jdoubleArray c, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dsyrk(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a, lda, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dsyrk_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdouble beta, jdoubleArray c, jint _c_offset, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_dsyrk(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a + _a_offset, lda, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtbmv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtbmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtbmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtbmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtbsv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtbsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtbsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtbsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtpmv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray ap, jdoubleArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtpmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtpmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtpmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap + _ap_offset, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtpsv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray ap, jdoubleArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtpsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtpsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray ap, jint _ap_offset, jdoubleArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtpsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap + _ap_offset, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrmm (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray b, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_dtrmm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a, lda, jni_b, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrmm_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_dtrmm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrmv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray a, jint lda, jdoubleArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtrmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtrmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrsm (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jdouble alpha, jdoubleArray a, jint lda, jdoubleArray b, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_dtrsm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a, lda, jni_b, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrsm_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jdouble alpha, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray b, jint _b_offset, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_dtrsm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrsv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray a, jint lda, jdoubleArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtrsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_dtrsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jdoubleArray a, jint _a_offset, jint lda, jdoubleArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jdouble * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jdouble * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_dtrsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT jint JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_idamax (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint incx) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jint returnValue = cblas_idamax(n, jni_dx, incx);
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
  return returnValue;
}

JNIEXPORT jint JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_idamax_1offsets (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dx, jint _dx_offset, jint incx) {
  jdouble * jni_dx = NULL;
  if (dx != NULL) {
    jni_dx = (*env)->GetPrimitiveArrayCritical(env, dx, JNI_FALSE);
    check_memory(env, jni_dx);
  }
  jint returnValue = cblas_idamax(n, jni_dx + _dx_offset, incx);
  if (dx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dx, jni_dx, 0);
  }
  return returnValue;
}

JNIEXPORT jint JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_isamax (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint incx) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jint returnValue = cblas_isamax(n, jni_sx, incx);
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT jint JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_isamax_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint _sx_offset, jint incx) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jint returnValue = cblas_isamax(n, jni_sx + _sx_offset, incx);
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sasum (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint incx) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat returnValue = cblas_sasum(n, jni_sx, incx);
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sasum_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint _sx_offset, jint incx) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat returnValue = cblas_sasum(n, jni_sx + _sx_offset, incx);
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_saxpy (JNIEnv * env, jobject calling_obj, jint n, jfloat sa, jfloatArray sx, jint incx, jfloatArray sy, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_saxpy(n, sa, jni_sx, incx, jni_sy, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_saxpy_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloat sa, jfloatArray sx, jint _sx_offset, jint incx, jfloatArray sy, jint _sy_offset, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_saxpy(n, sa, jni_sx + _sx_offset, incx, jni_sy + _sy_offset, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_scopy (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint incx, jfloatArray sy, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_scopy(n, jni_sx, incx, jni_sy, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_scopy_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint _sx_offset, jint incx, jfloatArray sy, jint _sy_offset, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_scopy(n, jni_sx + _sx_offset, incx, jni_sy + _sy_offset, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sdot (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint incx, jfloatArray sy, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
  jfloat returnValue = cblas_sdot(n, jni_sx, incx, jni_sy, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sdot_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint _sx_offset, jint incx, jfloatArray sy, jint _sy_offset, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
  jfloat returnValue = cblas_sdot(n, jni_sx + _sx_offset, incx, jni_sy + _sy_offset, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sdsdot (JNIEnv * env, jobject calling_obj, jint n, jfloat sb, jfloatArray sx, jint incx, jfloatArray sy, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
  jfloat returnValue = cblas_sdsdot(n, sb, jni_sx, incx, jni_sy, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sdsdot_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloat sb, jfloatArray sx, jint _sx_offset, jint incx, jfloatArray sy, jint _sy_offset, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
  jfloat returnValue = cblas_sdsdot(n, sb, jni_sx + _sx_offset, incx, jni_sy + _sy_offset, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
  return returnValue;
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sgbmv (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint kl, jint ku, jfloat alpha, jfloatArray a, jint lda, jfloatArray x, jint incx, jfloat beta, jfloatArray y, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_sgbmv(CblasColMajor, getCblasTrans(jni_trans), m, n, kl, ku, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sgbmv_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint kl, jint ku, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx, jfloat beta, jfloatArray y, jint _y_offset, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_sgbmv(CblasColMajor, getCblasTrans(jni_trans), m, n, kl, ku, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sgemm (JNIEnv * env, jobject calling_obj, jstring transa, jstring transb, jint m, jint n, jint k, jfloat alpha, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloat beta, jfloatArray c, jint Ldc) {
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_transb = (char *)(*env)->GetStringUTFChars(env, transb, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_sgemm(CblasColMajor, getCblasTrans(jni_transa), getCblasTrans(jni_transb), m, n, k, alpha, jni_a, lda, jni_b, ldb, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, transb, jni_transb);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sgemm_1offsets (JNIEnv * env, jobject calling_obj, jstring transa, jstring transb, jint m, jint n, jint k, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jfloat beta, jfloatArray c, jint _c_offset, jint Ldc) {
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_transb = (char *)(*env)->GetStringUTFChars(env, transb, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_sgemm(CblasColMajor, getCblasTrans(jni_transa), getCblasTrans(jni_transb), m, n, k, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, transb, jni_transb);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sgemv (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jfloat alpha, jfloatArray a, jint lda, jfloatArray x, jint incx, jfloat beta, jfloatArray y, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_sgemv(CblasColMajor, getCblasTrans(jni_trans), m, n, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sgemv_1offsets (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx, jfloat beta, jfloatArray y, jint _y_offset, jint incy) {
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_sgemv(CblasColMajor, getCblasTrans(jni_trans), m, n, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sger (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloat alpha, jfloatArray x, jint incx, jfloatArray y, jint incy, jfloatArray a, jint lda) {
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_sger(CblasColMajor, m, n, alpha, jni_x, incx, jni_y, incy, jni_a, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sger_1offsets (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloat alpha, jfloatArray x, jint _x_offset, jint incx, jfloatArray y, jint _y_offset, jint incy, jfloatArray a, jint _a_offset, jint lda) {
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_sger(CblasColMajor, m, n, alpha, jni_x + _x_offset, incx, jni_y + _y_offset, incy, jni_a + _a_offset, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_snrm2 (JNIEnv * env, jobject calling_obj, jint n, jfloatArray x, jint incx) {
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat returnValue = cblas_snrm2(n, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  return returnValue;
}

JNIEXPORT jfloat JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_snrm2_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray x, jint _x_offset, jint incx) {
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat returnValue = cblas_snrm2(n, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  return returnValue;
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_srot (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint incx, jfloatArray sy, jint incy, jfloat c, jfloat s) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_srot(n, jni_sx, incx, jni_sy, incy, c, s);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_srot_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint _sx_offset, jint incx, jfloatArray sy, jint _sy_offset, jint incy, jfloat c, jfloat s) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_srot(n, jni_sx + _sx_offset, incx, jni_sy + _sy_offset, incy, c, s);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_srotg (JNIEnv * env, jobject calling_obj, jfloatw sa, jfloatw sb, jfloatw c, jfloatw s) {
  jclass jni_saClass = (*env)->GetObjectClass(env, sa);
  jfieldID jni_saId = (*env)->GetFieldID(env, jni_saClass, "val", "F");
  jfloat jni_sa = (*env)->GetFloatField(env, sa, jni_saId);
  jclass jni_sbClass = (*env)->GetObjectClass(env, sb);
  jfieldID jni_sbId = (*env)->GetFieldID(env, jni_sbClass, "val", "F");
  jfloat jni_sb = (*env)->GetFloatField(env, sb, jni_sbId);
  jclass jni_cClass = (*env)->GetObjectClass(env, c);
  jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "F");
  jfloat jni_c = (*env)->GetFloatField(env, c, jni_cId);
  jclass jni_sClass = (*env)->GetObjectClass(env, s);
  jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "F");
  jfloat jni_s = (*env)->GetFloatField(env, s, jni_sId);
cblas_srotg(&jni_sa, &jni_sb, &jni_c, &jni_s);
  (*env)->SetFloatField(env, s, jni_sId, jni_s);
  (*env)->SetFloatField(env, c, jni_cId, jni_c);
  (*env)->SetFloatField(env, sb, jni_sbId, jni_sb);
  (*env)->SetFloatField(env, sa, jni_saId, jni_sa);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_srotm (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint incx, jfloatArray sy, jint incy, jfloatArray sparam) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
  jfloat * jni_sparam = NULL;
  if (sparam != NULL) {
    jni_sparam = (*env)->GetPrimitiveArrayCritical(env, sparam, JNI_FALSE);
    check_memory(env, jni_sparam);
  }
cblas_srotm(n, jni_sx, incx, jni_sy, incy, jni_sparam);
  if (sparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sparam, jni_sparam, 0);
  }
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_srotm_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint _sx_offset, jint incx, jfloatArray sy, jint _sy_offset, jint incy, jfloatArray sparam, jint _sparam_offset) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
  jfloat * jni_sparam = NULL;
  if (sparam != NULL) {
    jni_sparam = (*env)->GetPrimitiveArrayCritical(env, sparam, JNI_FALSE);
    check_memory(env, jni_sparam);
  }
cblas_srotm(n, jni_sx + _sx_offset, incx, jni_sy + _sy_offset, incy, jni_sparam + _sparam_offset);
  if (sparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sparam, jni_sparam, 0);
  }
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_srotmg (JNIEnv * env, jobject calling_obj, jfloatw sd1, jfloatw sd2, jfloatw sx1, jfloat sy1, jfloatArray sparam) {
  jclass jni_sd1Class = (*env)->GetObjectClass(env, sd1);
  jfieldID jni_sd1Id = (*env)->GetFieldID(env, jni_sd1Class, "val", "F");
  jfloat jni_sd1 = (*env)->GetFloatField(env, sd1, jni_sd1Id);
  jclass jni_sd2Class = (*env)->GetObjectClass(env, sd2);
  jfieldID jni_sd2Id = (*env)->GetFieldID(env, jni_sd2Class, "val", "F");
  jfloat jni_sd2 = (*env)->GetFloatField(env, sd2, jni_sd2Id);
  jclass jni_sx1Class = (*env)->GetObjectClass(env, sx1);
  jfieldID jni_sx1Id = (*env)->GetFieldID(env, jni_sx1Class, "val", "F");
  jfloat jni_sx1 = (*env)->GetFloatField(env, sx1, jni_sx1Id);
  jfloat * jni_sparam = NULL;
  if (sparam != NULL) {
    jni_sparam = (*env)->GetPrimitiveArrayCritical(env, sparam, JNI_FALSE);
    check_memory(env, jni_sparam);
  }
cblas_srotmg(&jni_sd1, &jni_sd2, &jni_sx1, sy1, jni_sparam);
  if (sparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sparam, jni_sparam, 0);
  }
  (*env)->SetFloatField(env, sx1, jni_sx1Id, jni_sx1);
  (*env)->SetFloatField(env, sd2, jni_sd2Id, jni_sd2);
  (*env)->SetFloatField(env, sd1, jni_sd1Id, jni_sd1);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_srotmg_1offsets (JNIEnv * env, jobject calling_obj, jfloatw sd1, jfloatw sd2, jfloatw sx1, jfloat sy1, jfloatArray sparam, jint _sparam_offset) {
  jclass jni_sd1Class = (*env)->GetObjectClass(env, sd1);
  jfieldID jni_sd1Id = (*env)->GetFieldID(env, jni_sd1Class, "val", "F");
  jfloat jni_sd1 = (*env)->GetFloatField(env, sd1, jni_sd1Id);
  jclass jni_sd2Class = (*env)->GetObjectClass(env, sd2);
  jfieldID jni_sd2Id = (*env)->GetFieldID(env, jni_sd2Class, "val", "F");
  jfloat jni_sd2 = (*env)->GetFloatField(env, sd2, jni_sd2Id);
  jclass jni_sx1Class = (*env)->GetObjectClass(env, sx1);
  jfieldID jni_sx1Id = (*env)->GetFieldID(env, jni_sx1Class, "val", "F");
  jfloat jni_sx1 = (*env)->GetFloatField(env, sx1, jni_sx1Id);
  jfloat * jni_sparam = NULL;
  if (sparam != NULL) {
    jni_sparam = (*env)->GetPrimitiveArrayCritical(env, sparam, JNI_FALSE);
    check_memory(env, jni_sparam);
  }
cblas_srotmg(&jni_sd1, &jni_sd2, &jni_sx1, sy1, jni_sparam + _sparam_offset);
  if (sparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sparam, jni_sparam, 0);
  }
  (*env)->SetFloatField(env, sx1, jni_sx1Id, jni_sx1);
  (*env)->SetFloatField(env, sd2, jni_sd2Id, jni_sd2);
  (*env)->SetFloatField(env, sd1, jni_sd1Id, jni_sd1);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssbmv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint k, jfloat alpha, jfloatArray a, jint lda, jfloatArray x, jint incx, jfloat beta, jfloatArray y, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_ssbmv(CblasColMajor, getCblasUpLo(jni_uplo), n, k, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssbmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint k, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx, jfloat beta, jfloatArray y, jint _y_offset, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_ssbmv(CblasColMajor, getCblasUpLo(jni_uplo), n, k, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sscal (JNIEnv * env, jobject calling_obj, jint n, jfloat sa, jfloatArray sx, jint incx) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
cblas_sscal(n, sa, jni_sx, incx);
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sscal_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloat sa, jfloatArray sx, jint _sx_offset, jint incx) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
cblas_sscal(n, sa, jni_sx + _sx_offset, incx);
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sspmv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray ap, jfloatArray x, jint incx, jfloat beta, jfloatArray y, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_sspmv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_ap, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sspmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray ap, jint _ap_offset, jfloatArray x, jint _x_offset, jint incx, jfloat beta, jfloatArray y, jint _y_offset, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_sspmv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_ap + _ap_offset, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sspr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint incx, jfloatArray ap) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_sspr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_ap);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sspr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint _x_offset, jint incx, jfloatArray ap, jint _ap_offset) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_sspr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_ap + _ap_offset);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sspr2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint incx, jfloatArray y, jint incy, jfloatArray ap) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_sspr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_y, incy, jni_ap);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sspr2_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint _x_offset, jint incx, jfloatArray y, jint _y_offset, jint incy, jfloatArray ap, jint _ap_offset) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
cblas_sspr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_y + _y_offset, incy, jni_ap + _ap_offset);
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sswap (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint incx, jfloatArray sy, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_sswap(n, jni_sx, incx, jni_sy, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_sswap_1offsets (JNIEnv * env, jobject calling_obj, jint n, jfloatArray sx, jint _sx_offset, jint incx, jfloatArray sy, jint _sy_offset, jint incy) {
  jfloat * jni_sx = NULL;
  if (sx != NULL) {
    jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
    check_memory(env, jni_sx);
  }
  jfloat * jni_sy = NULL;
  if (sy != NULL) {
    jni_sy = (*env)->GetPrimitiveArrayCritical(env, sy, JNI_FALSE);
    check_memory(env, jni_sy);
  }
cblas_sswap(n, jni_sx + _sx_offset, incx, jni_sy + _sy_offset, incy);
  if (sy != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sy, jni_sy, 0);
  }
  if (sx != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
  }
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssymm (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jint m, jint n, jfloat alpha, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloat beta, jfloatArray c, jint Ldc) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_ssymm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), m, n, alpha, jni_a, lda, jni_b, ldb, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssymm_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jint m, jint n, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jfloat beta, jfloatArray c, jint _c_offset, jint Ldc) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_ssymm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), m, n, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssymv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray a, jint lda, jfloatArray x, jint incx, jfloat beta, jfloatArray y, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_ssymv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_a, lda, jni_x, incx, beta, jni_y, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssymv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx, jfloat beta, jfloatArray y, jint _y_offset, jint incy) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
cblas_ssymv(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_a + _a_offset, lda, jni_x + _x_offset, incx, beta, jni_y + _y_offset, incy);
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint incx, jfloatArray a, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_ssyr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_a, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyr_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint _x_offset, jint incx, jfloatArray a, jint _a_offset, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_ssyr(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_a + _a_offset, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyr2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint incx, jfloatArray y, jint incy, jfloatArray a, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_ssyr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x, incx, jni_y, incy, jni_a, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyr2_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloat alpha, jfloatArray x, jint _x_offset, jint incx, jfloatArray y, jint _y_offset, jint incy, jfloatArray a, jint _a_offset, jint lda) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
  jfloat * jni_y = NULL;
  if (y != NULL) {
    jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
    check_memory(env, jni_y);
  }
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
cblas_ssyr2(CblasColMajor, getCblasUpLo(jni_uplo), n, alpha, jni_x + _x_offset, incx, jni_y + _y_offset, incy, jni_a + _a_offset, lda);
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  if (y != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
  }
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyr2k (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jfloat alpha, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloat beta, jfloatArray c, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_ssyr2k(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a, lda, jni_b, ldb, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyr2k_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb, jfloat beta, jfloatArray c, jint _c_offset, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_ssyr2k(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyrk (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jfloat alpha, jfloatArray a, jint lda, jfloat beta, jfloatArray c, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_ssyrk(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a, lda, beta, jni_c, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_ssyrk_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jint n, jint k, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloat beta, jfloatArray c, jint _c_offset, jint Ldc) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_c = NULL;
  if (c != NULL) {
    jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
    check_memory(env, jni_c);
  }
cblas_ssyrk(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), n, k, alpha, jni_a + _a_offset, lda, beta, jni_c + _c_offset, Ldc);
  if (c != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stbmv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jfloatArray a, jint lda, jfloatArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stbmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stbmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stbmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stbsv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jfloatArray a, jint lda, jfloatArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stbsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stbsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint k, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stbsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, k, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stpmv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray ap, jfloatArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stpmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stpmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray ap, jint _ap_offset, jfloatArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stpmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap + _ap_offset, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stpsv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray ap, jfloatArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stpsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_stpsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray ap, jint _ap_offset, jfloatArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_ap = NULL;
  if (ap != NULL) {
    jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
    check_memory(env, jni_ap);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_stpsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_ap + _ap_offset, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (ap != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strmm (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jfloat alpha, jfloatArray a, jint lda, jfloatArray b, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_strmm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a, lda, jni_b, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strmm_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_strmm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strmv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray a, jint lda, jfloatArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_strmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strmv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_strmv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strsm (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jfloat alpha, jfloatArray a, jint lda, jfloatArray b, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_strsm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a, lda, jni_b, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strsm_1offsets (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring transa, jstring diag, jint m, jint n, jfloat alpha, jfloatArray a, jint _a_offset, jint lda, jfloatArray b, jint _b_offset, jint ldb) {
  char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_transa = (char *)(*env)->GetStringUTFChars(env, transa, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_b = NULL;
  if (b != NULL) {
    jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
    check_memory(env, jni_b);
  }
cblas_strsm(CblasColMajor, getCblasSide(jni_side), getCblasUpLo(jni_uplo), getCblasTrans(jni_transa), getCblasDiag(jni_diag), m, n, alpha, jni_a + _a_offset, lda, jni_b + _b_offset, ldb);
  if (b != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, transa, jni_transa);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
  (*env)->ReleaseStringUTFChars(env, side, jni_side);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strsv (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray a, jint lda, jfloatArray x, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_strsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a, lda, jni_x, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeSystemBLAS_strsv_1offsets (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jfloatArray a, jint _a_offset, jint lda, jfloatArray x, jint _x_offset, jint incx) {
  char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
  char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
  char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
  jfloat * jni_a = NULL;
  if (a != NULL) {
    jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
    check_memory(env, jni_a);
  }
  jfloat * jni_x = NULL;
  if (x != NULL) {
    jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
    check_memory(env, jni_x);
  }
cblas_strsv(CblasColMajor, getCblasUpLo(jni_uplo), getCblasTrans(jni_trans), getCblasDiag(jni_diag), n, jni_a + _a_offset, lda, jni_x + _x_offset, incx);
  if (x != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
  }
  if (a != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
  }
  (*env)->ReleaseStringUTFChars(env, diag, jni_diag);
  (*env)->ReleaseStringUTFChars(env, trans, jni_trans);
  (*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
}