/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.Header;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpVersion;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ParseException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ProtocolVersionParser;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.BasicHeader;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.LineParser;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.ParserCursor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.RequestLine;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.StatusLine;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.CharArrayBuffer;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.TextUtils;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Tokenizer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicLineParser
implements LineParser {
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    private static final Tokenizer.Delimiter BLANKS = Tokenizer.delimiters(' ', '\t');
    private static final Tokenizer.Delimiter COLON = Tokenizer.delimiters(':');
    private final ProtocolVersion protocol;
    private final Tokenizer tokenizer;

    public BasicLineParser(ProtocolVersion proto) {
        this.protocol = proto != null ? proto : HttpVersion.HTTP_1_1;
        this.tokenizer = Tokenizer.INSTANCE;
    }

    public BasicLineParser() {
        this(null);
    }

    ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        int pos = cursor.getPos();
        if (pos + protolength + 4 > cursor.getUpperBound()) {
            throw new ParseException("Invalid protocol version", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        boolean ok = true;
        for (int i = 0; ok && i < protolength; ++i) {
            ok = buffer.charAt(pos + i) == protoname.charAt(i);
        }
        if (ok) {
            boolean bl = ok = buffer.charAt(pos + protolength) == '/';
        }
        if (!ok) {
            throw new ParseException("Invalid protocol version", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        cursor.updatePos(pos + protolength + 1);
        return ProtocolVersionParser.INSTANCE.parse(protoname, HttpVersion::get, buffer, cursor, null);
    }

    @Override
    public RequestLine parseRequestLine(CharArrayBuffer buffer) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String method = this.tokenizer.parseToken((CharSequence)buffer, (Tokenizer.Cursor)cursor, BLANKS);
        if (TextUtils.isEmpty(method)) {
            throw new ParseException("Invalid request line", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String uri = this.tokenizer.parseToken((CharSequence)buffer, (Tokenizer.Cursor)cursor, BLANKS);
        if (TextUtils.isEmpty(uri)) {
            throw new ParseException("Invalid request line", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        if (!cursor.atEnd()) {
            throw new ParseException("Invalid request line", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        return new RequestLine(method, uri, ver);
    }

    @Override
    public StatusLine parseStatusLine(CharArrayBuffer buffer) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        int statusCode = 0;
        for (int i = 1; i <= 3; ++i) {
            if (cursor.atEnd()) {
                throw new ParseException("Status line contains invalid status code", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
            }
            char ch = buffer.charAt(cursor.getPos());
            if (ch < '0' || ch > '9') {
                throw new ParseException("Status line contains invalid status code", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
            }
            statusCode = statusCode * 10 + (ch - 48);
            cursor.updatePos(cursor.getPos() + 1);
        }
        if (!cursor.atEnd()) {
            char ch = buffer.charAt(cursor.getPos());
            if (Tokenizer.isWhitespace(ch)) {
                cursor.updatePos(cursor.getPos() + 1);
            } else {
                throw new ParseException("Status line contains invalid status code", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
            }
        }
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String text = buffer.substringTrimmed(cursor.getPos(), cursor.getUpperBound());
        return new StatusLine(ver, statusCode, text);
    }

    @Override
    public Header parseHeader(CharArrayBuffer buffer) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String name = this.tokenizer.parseToken((CharSequence)buffer, (Tokenizer.Cursor)cursor, COLON);
        if (cursor.getPos() == cursor.getLowerBound() || cursor.getPos() == cursor.getUpperBound() || buffer.charAt(cursor.getPos()) != ':' || TextUtils.isEmpty(name) || Tokenizer.isWhitespace(buffer.charAt(cursor.getPos() - 1))) {
            throw new ParseException("Invalid header", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        String value = buffer.substringTrimmed(cursor.getPos() + 1, cursor.getUpperBound());
        return new BasicHeader(name, value);
    }
}

