/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2.internal;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree2.geometry.Geometries;
import com.github.davidmoten.rtree2.geometry.HasGeometry;
import com.github.davidmoten.rtree2.geometry.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Util {
    private Util() {
    }

    public static Rectangle mbr(Collection<? extends HasGeometry> items) {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0);
        double minX1 = Double.MAX_VALUE;
        double minY1 = Double.MAX_VALUE;
        double maxX2 = -1.7976931348623157E308;
        double maxY2 = -1.7976931348623157E308;
        boolean isDoublePrecision = false;
        for (HasGeometry hasGeometry : items) {
            Rectangle r = hasGeometry.geometry().mbr();
            if (r.isDoublePrecision()) {
                isDoublePrecision = true;
            }
            if (r.x1() < minX1) {
                minX1 = r.x1();
            }
            if (r.y1() < minY1) {
                minY1 = r.y1();
            }
            if (r.x2() > maxX2) {
                maxX2 = r.x2();
            }
            if (!(r.y2() > maxY2)) continue;
            maxY2 = r.y2();
        }
        if (isDoublePrecision) {
            return Geometries.rectangle(minX1, minY1, maxX2, maxY2);
        }
        return Geometries.rectangle((float)minX1, (float)minY1, (float)maxX2, (float)maxY2);
    }

    public static <T> List<T> add(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 2);
        result.addAll(list);
        result.add(element);
        return result;
    }

    public static <T> List<T> remove(List<? extends T> list, List<? extends T> elements) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(elements);
        return result;
    }

    public static <T> List<? extends T> replace(List<? extends T> list, T element, List<T> replacements) {
        ArrayList<T> list2 = new ArrayList<T>(list.size() + replacements.size());
        for (T node : list) {
            if (node == element) continue;
            list2.add(node);
        }
        list2.addAll(replacements);
        return list2;
    }
}

