/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2.internal;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree2.Entry;
import com.github.davidmoten.rtree2.geometry.Geometry;
import com.github.davidmoten.rtree2.internal.util.ObjectsHelper;

public final class EntryDefault<T, S extends Geometry>
implements Entry<T, S> {
    private final T value;
    private final S geometry;

    public EntryDefault(T value, S geometry) {
        Preconditions.checkNotNull(geometry);
        this.value = value;
        this.geometry = geometry;
    }

    public static <T, S extends Geometry> Entry<T, S> entry(T value, S geometry) {
        return new EntryDefault<T, S>(value, geometry);
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public S geometry() {
        return this.geometry;
    }

    public String toString() {
        String builder = "Entry [value=" + this.value + ", geometry=" + this.geometry + "]";
        return builder;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.geometry});
    }

    public boolean equals(Object obj) {
        EntryDefault other = ObjectsHelper.asClass(obj, EntryDefault.class);
        if (other != null) {
            return Objects.equal(this.value, other.value) && Objects.equal(this.geometry, other.geometry);
        }
        return false;
    }
}

