/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2.geometry.internal;

import com.github.davidmoten.rtree2.geometry.Geometry;
import com.github.davidmoten.rtree2.geometry.Point;
import com.github.davidmoten.rtree2.geometry.Rectangle;
import com.github.davidmoten.rtree2.geometry.internal.GeometryUtil;
import com.github.davidmoten.rtree2.geometry.internal.PointDouble;
import com.github.davidmoten.rtree2.geometry.internal.RectangleDouble;
import com.github.davidmoten.rtree2.geometry.internal.RectangleFloat;

public final class PointFloat
implements Point {
    private final float x;
    private final float y;

    private PointFloat(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public static PointFloat create(float x, float y) {
        return new PointFloat(x, y);
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    @Override
    public double distance(Rectangle r) {
        return GeometryUtil.distance(this.x, this.y, r);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return r.x1() <= (double)this.x && (double)this.x <= r.x2() && r.y1() <= (double)this.y && (double)this.y <= r.y2();
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointFloat other = (PointFloat)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    public String toString() {
        return "Point [x=" + this.x() + ", y=" + this.y() + "]";
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    @Override
    public double x1() {
        return this.x;
    }

    @Override
    public double y1() {
        return this.y;
    }

    @Override
    public double x2() {
        return this.x;
    }

    @Override
    public double y2() {
        return this.y;
    }

    @Override
    public double area() {
        return 0.0;
    }

    @Override
    public Rectangle add(Rectangle r) {
        if (r.isDoublePrecision()) {
            return RectangleDouble.create(Math.min((double)this.x, r.x1()), Math.min((double)this.y, r.y1()), Math.max((double)this.x, r.x2()), Math.max((double)this.y, r.y2()));
        }
        if (r instanceof RectangleFloat) {
            RectangleFloat rf = (RectangleFloat)r;
            return RectangleFloat.create(Math.min(this.x, rf.x1), Math.min(this.y, rf.y1), Math.max(this.x, rf.x2), Math.max(this.y, rf.y2));
        }
        if (r instanceof PointFloat) {
            PointFloat p = (PointFloat)r;
            return RectangleFloat.create(Math.min(this.x, p.x), Math.min(this.y, p.y), Math.max(this.x, p.x), Math.max(this.y, p.y));
        }
        PointDouble p = (PointDouble)r;
        return RectangleDouble.create(Math.min((double)this.x, p.x()), Math.min((double)this.y, p.y()), Math.max((double)this.x, p.x()), Math.max((double)this.y, p.y()));
    }

    @Override
    public boolean contains(double x, double y) {
        return (double)this.x == x && (double)this.y == y;
    }

    @Override
    public double intersectionArea(Rectangle r) {
        return 0.0;
    }

    @Override
    public double perimeter() {
        return 0.0;
    }

    @Override
    public boolean isDoublePrecision() {
        return false;
    }

    public float xFloat() {
        return this.x;
    }

    public float yFloat() {
        return this.y;
    }
}

