/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.watchdog;

import backtraceio.library.BacktraceClient;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.json.BacktraceReport;
import backtraceio.library.watchdog.BacktraceWatchdogTimeoutException;
import backtraceio.library.watchdog.OnApplicationNotRespondingEvent;
import java.util.HashMap;
import java.util.Map;

class BacktraceWatchdogShared {
    BacktraceWatchdogShared() {
    }

    static void sendReportCauseBlockedThread(BacktraceClient backtraceClient, Thread thread, OnApplicationNotRespondingEvent onApplicationNotRespondingEvent, String LOG_TAG) {
        BacktraceWatchdogTimeoutException exception = new BacktraceWatchdogTimeoutException();
        exception.setStackTrace(thread.getStackTrace());
        BacktraceLogger.e(LOG_TAG, "Blocked thread detected, sending a report", exception);
        if (onApplicationNotRespondingEvent != null) {
            onApplicationNotRespondingEvent.onEvent(exception);
        } else if (backtraceClient != null) {
            backtraceClient.addBreadcrumb("ANR detected - thread is blocked");
            BacktraceReport report = new BacktraceReport((Exception)exception, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("error.type", "Hang");
                }
            });
            backtraceClient.send(report);
        }
    }
}

