/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.services;

import android.os.Handler;
import android.os.Message;
import backtraceio.library.common.BacktraceMathHelper;
import backtraceio.library.common.BacktraceSerializeHelper;
import backtraceio.library.interfaces.Api;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.json.BacktraceAttributes;
import backtraceio.library.models.metrics.Event;
import backtraceio.library.models.metrics.EventsPayload;
import backtraceio.library.models.metrics.EventsResult;
import backtraceio.library.services.BacktraceHandlerInputEvents;
import backtraceio.library.services.BacktraceHandlerThread;
import backtraceio.library.services.BacktraceMetrics;
import backtraceio.library.services.BacktraceReportSender;
import java.util.concurrent.ConcurrentLinkedDeque;

abstract class BacktraceEventsHandler<T extends Event>
extends Handler {
    private static final transient String LOG_TAG = BacktraceEventsHandler.class.getSimpleName();
    protected final BacktraceHandlerThread backtraceHandlerThread;
    protected final BacktraceMetrics backtraceMetrics;
    private final int timeBetweenRetriesMillis;
    protected final Api api;
    private final String submissionUrl;
    protected ConcurrentLinkedDeque<T> events = new ConcurrentLinkedDeque();
    private int maximumNumberOfEvents = 350;
    protected String application;
    protected String appVersion;

    public BacktraceEventsHandler(BacktraceMetrics backtraceMetrics, Api api, BacktraceHandlerThread backtraceHandlerThread, String urlPrefix) {
        super(backtraceHandlerThread.getLooper());
        if (!backtraceHandlerThread.isAlive()) {
            throw new NullPointerException("Handler thread is not alive, this should not happen");
        }
        this.backtraceMetrics = backtraceMetrics;
        this.backtraceHandlerThread = backtraceHandlerThread;
        this.api = api;
        this.submissionUrl = backtraceMetrics.settings.getSubmissionUrl(urlPrefix);
        this.timeBetweenRetriesMillis = backtraceMetrics.settings.getTimeBetweenRetriesMillis();
        final long timeIntervalMillis = backtraceMetrics.settings.getTimeIntervalMillis();
        BacktraceAttributes backtraceAttributes = new BacktraceAttributes(backtraceMetrics.context, null, null);
        this.application = backtraceAttributes.getApplicationName();
        this.appVersion = backtraceAttributes.getApplicationVersionOrEmpty();
        if (timeIntervalMillis != 0L) {
            final BacktraceEventsHandler handler = this;
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    handler.send();
                    handler.postDelayed(this, timeIntervalMillis);
                }
            }, timeIntervalMillis);
        }
    }

    public int getCount() {
        return this.events.size();
    }

    public int getMaximumNumberOfEvents() {
        return this.maximumNumberOfEvents;
    }

    public void setMaximumNumberOfEvents(int maximumNumberOfEvents) {
        this.maximumNumberOfEvents = maximumNumberOfEvents;
    }

    public void send() {
        if (this.events == null || this.events.size() == 0) {
            return;
        }
        this.sendEvents(this.events);
    }

    protected abstract void sendEvents(ConcurrentLinkedDeque<T> var1);

    protected abstract void sendEventsPayload(EventsPayload<T> var1);

    public void handleMessage(Message msg) {
        BacktraceHandlerInputEvents input = (BacktraceHandlerInputEvents)msg.obj;
        EventsResult result = this.getEventsResult(input);
        if (input.eventsOnServerResponseEventListener != null) {
            BacktraceLogger.d(LOG_TAG, "Processing result using custom event");
            input.eventsOnServerResponseEventListener.onEvent(result);
        }
        this.retrySendEvents(input, result.getStatusCode());
    }

    protected void onMaximumAttemptsReached(ConcurrentLinkedDeque<T> events) {
    }

    protected abstract EventsPayload<T> getEventsPayload();

    private long calculateNextRetryTime(int numRetries) {
        boolean jitterFraction = true;
        int backoffBase = 10;
        double value = (double)this.timeBetweenRetriesMillis * Math.pow(10.0, numRetries - 1);
        double retryLower = BacktraceMathHelper.clamp(value, 0.0, 300000.0);
        double retryUpper = retryLower + retryLower * 1.0;
        return (long)BacktraceMathHelper.uniform(retryLower, retryUpper);
    }

    private EventsResult getEventsResult(BacktraceHandlerInputEvents input) {
        EventsResult result;
        if (input.eventsRequestHandler != null) {
            BacktraceLogger.d(LOG_TAG, "Sending using custom request handler");
            result = input.eventsRequestHandler.onRequest(input.payload);
        } else {
            BacktraceLogger.d(LOG_TAG, "Sending report using default request handler");
            String json = BacktraceSerializeHelper.toJson(input.payload);
            result = BacktraceReportSender.sendEvents(this.submissionUrl, json, input.payload, input.serverErrorEventListener);
        }
        return result;
    }

    private void retrySendEvents(final BacktraceHandlerInputEvents input, int statusCode) {
        if (statusCode > 501 && statusCode != 505) {
            int numRetries;
            if ((numRetries = ++input.payload.numRetries) >= 3 || this.timeBetweenRetriesMillis == 0) {
                this.onMaximumAttemptsReached(input.payload.getEvents());
                return;
            }
            BacktraceEventsHandler handler = this;
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    EventsPayload payload = input.payload;
                    payload.setDroppedEvents(numRetries);
                    BacktraceEventsHandler.this.sendEventsPayload(payload);
                }
            }, this.calculateNextRetryTime(numRetries));
        }
    }
}

