/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models.database;

import android.content.Context;
import backtraceio.library.common.BacktraceSerializeHelper;
import backtraceio.library.common.BacktraceStringHelper;
import backtraceio.library.common.FileHelper;
import backtraceio.library.interfaces.DatabaseRecordWriter;
import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceData;
import backtraceio.library.models.database.BacktraceDatabaseRecordWriter;
import backtraceio.library.models.json.BacktraceReport;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class BacktraceDatabaseRecord {
    private static final transient String LOG_TAG = BacktraceDatabaseRecord.class.getSimpleName();
    private final transient String _path;
    @SerializedName(value="Id")
    public UUID id = UUID.randomUUID();
    public transient boolean locked = false;
    transient DatabaseRecordWriter RecordWriter;
    @SerializedName(value="RecordName")
    private String recordPath;
    @SerializedName(value="DataPath")
    private String diagnosticDataPath;
    @SerializedName(value="ReportPath")
    private String reportPath;
    @SerializedName(value="Size")
    private long size;
    private transient BacktraceData record;

    BacktraceDatabaseRecord() {
        this._path = "";
        this.recordPath = String.format("%s-record.json", this.id);
        this.diagnosticDataPath = String.format("%s-attachment", this.id);
    }

    public BacktraceDatabaseRecord(BacktraceData data, String path) {
        this.id = UUID.fromString(data.uuid);
        this.record = data;
        this._path = path;
        this.RecordWriter = new BacktraceDatabaseRecordWriter(path);
    }

    public static BacktraceDatabaseRecord readFromFile(File file) {
        BacktraceLogger.d(LOG_TAG, "Reading JSON from passed file");
        String json = FileHelper.readFile(file);
        if (BacktraceStringHelper.isNullOrEmpty(json)) {
            BacktraceLogger.w(LOG_TAG, "JSON from passed file is null or empty");
            return null;
        }
        return BacktraceSerializeHelper.fromJson(json, BacktraceDatabaseRecord.class);
    }

    public String getRecordPath() {
        return this.recordPath;
    }

    public String getDiagnosticDataPath() {
        return this.diagnosticDataPath;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public BacktraceData getBacktraceData(Context context) {
        if (this.record != null) {
            return this.record;
        }
        if (!this.valid()) {
            BacktraceLogger.w(LOG_TAG, "Database record is invalid");
            return null;
        }
        String jsonData = FileHelper.readFile(new File(this.diagnosticDataPath));
        String jsonReport = FileHelper.readFile(new File(this.reportPath));
        try {
            BacktraceLogger.d(LOG_TAG, "Deserialization diagnostic data");
            BacktraceData diagnosticData = BacktraceSerializeHelper.fromJson(jsonData, BacktraceData.class);
            diagnosticData.report = BacktraceSerializeHelper.fromJson(jsonReport, BacktraceReport.class);
            diagnosticData.context = context;
            return diagnosticData;
        }
        catch (Exception ex) {
            BacktraceLogger.e(LOG_TAG, "Exception occurs on deserialization of diagnostic data", ex);
            return null;
        }
    }

    public boolean save() {
        try {
            BacktraceLogger.d(LOG_TAG, "Trying saving data to internal app storage");
            this.diagnosticDataPath = this.save(this.record, String.format("%s-attachment", this.id));
            this.reportPath = this.save(this.record.report, String.format("%s-report", this.id));
            this.recordPath = new File(this._path, String.format("%s-record.json", this.id)).getAbsolutePath();
            String json = BacktraceSerializeHelper.toJson(this);
            byte[] file = json.getBytes(StandardCharsets.UTF_8);
            this.size += (long)file.length;
            this.RecordWriter.write(this, String.format("%s-record", this.id));
            BacktraceLogger.d(LOG_TAG, "Saving data to internal app storage successful");
            return true;
        }
        catch (Exception ex) {
            BacktraceLogger.e(LOG_TAG, "Received IOException while saving data to database", ex);
            return false;
        }
    }

    private String save(Object data, String prefix) {
        try {
            if (data == null) {
                BacktraceLogger.w(LOG_TAG, "Passed data parameter is null");
                return "";
            }
            String json = BacktraceSerializeHelper.toJson(data);
            byte[] file = json.getBytes(StandardCharsets.UTF_8);
            this.size += (long)file.length;
            return this.RecordWriter.write(file, prefix);
        }
        catch (Exception ex) {
            BacktraceLogger.e(LOG_TAG, "Received IOException while saving data to database", ex);
            return "";
        }
    }

    public boolean valid() {
        return FileHelper.isFileExists(this.diagnosticDataPath) && FileHelper.isFileExists(this.reportPath);
    }

    public void delete() {
        BacktraceLogger.d(LOG_TAG, "Trying delete files from database");
        this.delete(this.reportPath);
        this.delete(this.diagnosticDataPath);
        this.delete(this.recordPath);
    }

    private void delete(String path) {
        try {
            if (FileHelper.isFileExists(path)) {
                BacktraceLogger.d(LOG_TAG, "Passed path exist, trying delete file on database record");
                new File(path).delete();
            }
        }
        catch (Exception ex) {
            BacktraceLogger.e(LOG_TAG, String.format("Cannot delete file: %s", path), ex);
        }
    }

    public boolean close() {
        BacktraceLogger.d(LOG_TAG, "Trying unlock database record");
        try {
            this.locked = false;
            this.record = null;
            BacktraceLogger.d(LOG_TAG, "Record unlocked");
            return true;
        }
        catch (Exception e) {
            BacktraceLogger.e(LOG_TAG, "Can not unlock record");
            return false;
        }
    }
}

