/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models;

import backtraceio.library.logger.BacktraceLogger;
import backtraceio.library.models.BacktraceStackFrame;
import java.util.ArrayList;

public class BacktraceStackTrace {
    private static final transient String LOG_TAG = BacktraceStackTrace.class.getSimpleName();
    private final Exception exception;
    private final ArrayList<BacktraceStackFrame> stackFrames = new ArrayList();

    public BacktraceStackTrace(Exception exception) {
        this.exception = exception;
        this.initialize();
    }

    public ArrayList<BacktraceStackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public Exception getException() {
        return this.exception;
    }

    private void initialize() {
        StackTraceElement[] stackTraceElements;
        StackTraceElement[] stackTraceElementArray = stackTraceElements = this.exception != null ? this.exception.getStackTrace() : Thread.currentThread().getStackTrace();
        if (stackTraceElements == null || stackTraceElements.length == 0) {
            BacktraceLogger.w(LOG_TAG, "StackTraceElements are null or empty");
            return;
        }
        this.setStacktraceInformation(stackTraceElements);
    }

    private void setStacktraceInformation(StackTraceElement[] frames) {
        if (frames == null || frames.length == 0) {
            BacktraceLogger.w(LOG_TAG, "StackTraceFrames are null or empty");
            return;
        }
        for (StackTraceElement frame : frames) {
            if (frame != null && frame.getFileName() != null && frame.getFileName().startsWith("Backtrace")) {
                BacktraceLogger.d(LOG_TAG, "Skipping frame because it comes from inside the Backtrace library");
                continue;
            }
            BacktraceStackFrame backtraceStackFrame = new BacktraceStackFrame(frame);
            this.stackFrames.add(backtraceStackFrame);
        }
    }
}

