/*
 * Decompiled with CFR 0.152.
 */
package backtraceio.library.models;

import backtraceio.library.BacktraceCredentials;

public class BacktraceMetricsSettings {
    private final String universe;
    private final String token;
    private final String baseUrl;
    private final long timeIntervalMillis;
    private final int timeBetweenRetriesMillis;

    public BacktraceMetricsSettings(BacktraceCredentials credentials) {
        this(credentials, "https://events.backtrace.io/api", 1800000L, 10000);
    }

    public BacktraceMetricsSettings(BacktraceCredentials credentials, String baseUrl) {
        this(credentials, baseUrl, 1800000L, 10000);
    }

    public BacktraceMetricsSettings(BacktraceCredentials credentials, long timeIntervalMillis) {
        this(credentials, "https://events.backtrace.io/api", timeIntervalMillis, 10000);
    }

    public BacktraceMetricsSettings(BacktraceCredentials credentials, String baseUrl, long timeIntervalMillis) {
        this(credentials, baseUrl, timeIntervalMillis, 10000);
    }

    public BacktraceMetricsSettings(BacktraceCredentials credentials, String baseUrl, long timeIntervalMillis, int timeBetweenRetriesMillis) {
        this.universe = credentials.getUniverseName();
        this.token = credentials.getSubmissionToken();
        this.baseUrl = baseUrl;
        this.timeIntervalMillis = timeIntervalMillis;
        this.timeBetweenRetriesMillis = timeBetweenRetriesMillis;
    }

    public String getUniverseName() {
        return this.universe;
    }

    public String getToken() {
        return this.token;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public long getTimeIntervalMillis() {
        return this.timeIntervalMillis;
    }

    public int getTimeBetweenRetriesMillis() {
        return this.timeBetweenRetriesMillis;
    }

    public String getSubmissionUrl(String urlPrefix) {
        return this.getBaseUrl() + "/" + urlPrefix + "/submit?token=" + this.getToken() + "&universe=" + this.getUniverseName();
    }
}

